/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.client.util;

import com.oceanbase.clogproxy.common.util.NetworkUtil;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.Scanner;

public class ClientUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getClientVersion() {
        try (InputStream inputStream = ClientUtil.class.getResourceAsStream("/com/oceanbase/clogproxy/client/version.txt");){
            String string = new Scanner(Objects.requireNonNull(inputStream)).useDelimiter(System.lineSeparator()).next().trim();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read project version", e);
        }
    }

    public static String generateClientId() {
        return NetworkUtil.getLocalIp() + "_" + ClientUtil.getProcessId() + "_" + System.currentTimeMillis() / 1000L;
    }

    private static String getProcessId() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return "NOPID";
        }
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException e) {
            return "NOPID";
        }
    }
}

