/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.client.connection;

import com.oceanbase.clogproxy.client.connection.ClientHandler;
import com.oceanbase.clogproxy.client.connection.Connection;
import com.oceanbase.clogproxy.client.connection.StreamContext;
import com.oceanbase.clogproxy.client.enums.ErrorCode;
import com.oceanbase.clogproxy.client.exception.LogProxyClientException;
import com.oceanbase.clogproxy.client.util.NamedThreadFactory;
import com.oceanbase.clogproxy.client.util.NettyEventLoopUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;

public class ConnectionFactory {
    public static final AttributeKey<StreamContext> CONTEXT_KEY = AttributeKey.valueOf("context");
    private static final EventLoopGroup WORKER_GROUP = NettyEventLoopUtil.newEventLoopGroup(1, new NamedThreadFactory("log-proxy-client-worker", true));

    public static ConnectionFactory instance() {
        return Singleton.INSTANCE;
    }

    private ConnectionFactory() {
    }

    private Bootstrap initBootstrap(final StreamContext context) {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.attr(CONTEXT_KEY, context)).group(WORKER_GROUP)).channel(NettyEventLoopUtil.getClientSocketChannelClass())).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, true);
        final SslContext sslContext = context.config().getSslContext();
        bootstrap.handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) {
                if (sslContext != null) {
                    ch.pipeline().addFirst(sslContext.newHandler(ch.alloc()));
                }
                ch.pipeline().addLast(new IdleStateHandler(context.config().getIdleTimeoutS(), 0, 0));
                ch.pipeline().addLast(new ClientHandler());
            }
        });
        return bootstrap;
    }

    public Connection createConnection(StreamContext context) throws LogProxyClientException {
        Bootstrap bootstrap = this.initBootstrap(context);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, context.config().getConnectTimeoutMs());
        ChannelFuture channelFuture = bootstrap.connect(new InetSocketAddress(context.params().getHost(), context.params().getPort()));
        channelFuture.awaitUninterruptibly();
        if (!channelFuture.isDone()) {
            throw new LogProxyClientException(ErrorCode.E_CONNECT, "timeout of create connection!");
        }
        if (channelFuture.isCancelled()) {
            throw new LogProxyClientException(ErrorCode.E_CONNECT, "cancelled by user of create connection!");
        }
        if (!channelFuture.isSuccess()) {
            throw new LogProxyClientException(ErrorCode.E_CONNECT, "failed to create connection!", channelFuture.cause());
        }
        return new Connection(channelFuture.channel());
    }

    private static class Singleton {
        private static final ConnectionFactory INSTANCE = new ConnectionFactory();

        private Singleton() {
        }
    }
}

