/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.table;

import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.apache.flink.cdc.debezium.table.MetadataConverter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;

public enum OceanBaseReadableMetadata {
    TENANT("tenant_name", (DataType)DataTypes.STRING().nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return StringData.fromString((String)sourceStruct.getString("tenant"));
        }
    }),
    DATABASE("database_name", (DataType)DataTypes.STRING().nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return StringData.fromString((String)sourceStruct.getString("db"));
        }
    }),
    SCHEMA("schema_name", (DataType)DataTypes.STRING().nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return StringData.fromString((String)sourceStruct.getString("schema"));
        }
    }),
    TABLE("table_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return StringData.fromString((String)sourceStruct.getString("table"));
        }
    }),
    OP_TS("op_ts", (DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return TimestampData.fromEpochMillis((long)sourceStruct.getInt64("ts_ms"));
        }
    });

    private final String key;
    private final DataType dataType;
    private final MetadataConverter converter;

    private OceanBaseReadableMetadata(String key, DataType dataType, MetadataConverter converter) {
        this.key = key;
        this.dataType = dataType;
        this.converter = converter;
    }

    public String getKey() {
        return this.key;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public MetadataConverter getConverter() {
        return this.converter;
    }
}

