/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.source.offset;

import io.debezium.connector.SourceInfoStructMaker;
import java.time.Instant;
import org.apache.flink.cdc.connectors.oceanbase.source.offset.OceanBaseSourceInfo;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;

public class OceanBaseSourceInfoStructMaker
implements SourceInfoStructMaker<OceanBaseSourceInfo> {
    private final Schema schema = SchemaBuilder.struct().field("table", Schema.STRING_SCHEMA).field("ts_ms", Schema.INT64_SCHEMA).field("tenant", Schema.OPTIONAL_STRING_SCHEMA).field("db", Schema.OPTIONAL_STRING_SCHEMA).field("schema", Schema.OPTIONAL_STRING_SCHEMA).field("transaction_id", Schema.OPTIONAL_STRING_SCHEMA).build();

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public Struct struct(OceanBaseSourceInfo sourceInfo) {
        Struct source = new Struct(this.schema);
        source.put("table", (Object)sourceInfo.table());
        Instant timestamp = sourceInfo.timestamp();
        source.put("ts_ms", (Object)(timestamp != null ? timestamp.toEpochMilli() : 0L));
        if (sourceInfo.tenant() != null) {
            source.put("tenant", (Object)sourceInfo.tenant());
        }
        if (sourceInfo.database() != null) {
            source.put("db", (Object)sourceInfo.database());
        }
        if (sourceInfo.tableSchema() != null) {
            source.put("schema", (Object)sourceInfo.tableSchema());
        }
        if (sourceInfo.transactionId() != null) {
            source.put("transaction_id", (Object)sourceInfo.transactionId());
        }
        return source;
    }
}

