/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.schema;

import io.debezium.relational.Column;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;

public class MySqlTypeUtils {
    private static final String BIT = "BIT";
    private static final String BOOLEAN = "BOOLEAN";
    private static final String BOOL = "BOOL";
    private static final String TINYINT = "TINYINT";
    private static final String TINYINT_UNSIGNED = "TINYINT UNSIGNED";
    private static final String TINYINT_UNSIGNED_ZEROFILL = "TINYINT UNSIGNED ZEROFILL";
    private static final String SMALLINT = "SMALLINT";
    private static final String SMALLINT_UNSIGNED = "SMALLINT UNSIGNED";
    private static final String SMALLINT_UNSIGNED_ZEROFILL = "SMALLINT UNSIGNED ZEROFILL";
    private static final String MEDIUMINT = "MEDIUMINT";
    private static final String MEDIUMINT_UNSIGNED = "MEDIUMINT UNSIGNED";
    private static final String MEDIUMINT_UNSIGNED_ZEROFILL = "MEDIUMINT UNSIGNED ZEROFILL";
    private static final String INT = "INT";
    private static final String INT_UNSIGNED = "INT UNSIGNED";
    private static final String INT_UNSIGNED_ZEROFILL = "INT UNSIGNED ZEROFILL";
    private static final String INTEGER = "INTEGER";
    private static final String INTEGER_UNSIGNED = "INTEGER UNSIGNED";
    private static final String INTEGER_UNSIGNED_ZEROFILL = "INTEGER UNSIGNED ZEROFILL";
    private static final String BIGINT = "BIGINT";
    private static final String SERIAL = "SERIAL";
    private static final String BIGINT_UNSIGNED = "BIGINT UNSIGNED";
    private static final String BIGINT_UNSIGNED_ZEROFILL = "BIGINT UNSIGNED ZEROFILL";
    private static final String REAL = "REAL";
    private static final String REAL_UNSIGNED = "REAL UNSIGNED";
    private static final String REAL_UNSIGNED_ZEROFILL = "REAL UNSIGNED ZEROFILL";
    private static final String FLOAT = "FLOAT";
    private static final String FLOAT_UNSIGNED = "FLOAT UNSIGNED";
    private static final String FLOAT_UNSIGNED_ZEROFILL = "FLOAT UNSIGNED ZEROFILL";
    private static final String DOUBLE = "DOUBLE";
    private static final String DOUBLE_UNSIGNED = "DOUBLE UNSIGNED";
    private static final String DOUBLE_UNSIGNED_ZEROFILL = "DOUBLE UNSIGNED ZEROFILL";
    private static final String DOUBLE_PRECISION = "DOUBLE PRECISION";
    private static final String DOUBLE_PRECISION_UNSIGNED = "DOUBLE PRECISION UNSIGNED";
    private static final String DOUBLE_PRECISION_UNSIGNED_ZEROFILL = "DOUBLE PRECISION UNSIGNED ZEROFILL";
    private static final String NUMERIC = "NUMERIC";
    private static final String NUMERIC_UNSIGNED = "NUMERIC UNSIGNED";
    private static final String NUMERIC_UNSIGNED_ZEROFILL = "NUMERIC UNSIGNED ZEROFILL";
    private static final String FIXED = "FIXED";
    private static final String FIXED_UNSIGNED = "FIXED UNSIGNED";
    private static final String FIXED_UNSIGNED_ZEROFILL = "FIXED UNSIGNED ZEROFILL";
    private static final String DECIMAL = "DECIMAL";
    private static final String DECIMAL_UNSIGNED = "DECIMAL UNSIGNED";
    private static final String DECIMAL_UNSIGNED_ZEROFILL = "DECIMAL UNSIGNED ZEROFILL";
    private static final String CHAR = "CHAR";
    private static final String VARCHAR = "VARCHAR";
    private static final String TINYTEXT = "TINYTEXT";
    private static final String MEDIUMTEXT = "MEDIUMTEXT";
    private static final String TEXT = "TEXT";
    private static final String LONGTEXT = "LONGTEXT";
    private static final String DATE = "DATE";
    private static final String TIME = "TIME";
    private static final String DATETIME = "DATETIME";
    private static final String TIMESTAMP = "TIMESTAMP";
    private static final String YEAR = "YEAR";
    private static final String BINARY = "BINARY";
    private static final String VARBINARY = "VARBINARY";
    private static final String TINYBLOB = "TINYBLOB";
    private static final String MEDIUMBLOB = "MEDIUMBLOB";
    private static final String BLOB = "BLOB";
    private static final String LONGBLOB = "LONGBLOB";
    private static final String JSON = "JSON";
    private static final String SET = "SET";
    private static final String ENUM = "ENUM";
    private static final String GEOMETRY = "GEOMETRY";
    private static final String POINT = "POINT";
    private static final String LINESTRING = "LINESTRING";
    private static final String POLYGON = "POLYGON";
    private static final String GEOMCOLLECTION = "GEOMCOLLECTION";
    private static final String GEOMETRYCOLLECTION = "GEOMETRYCOLLECTION";
    private static final String MULTIPOINT = "MULTIPOINT";
    private static final String MULTIPOLYGON = "MULTIPOLYGON";
    private static final String MULTILINESTRING = "MULTILINESTRING";
    private static final String UNKNOWN = "UNKNOWN";

    public static DataType fromDbzColumn(Column column, boolean tinyInt1isBit) {
        DataType dataType = MySqlTypeUtils.convertFromColumn(column, tinyInt1isBit);
        if (column.isOptional()) {
            return dataType;
        }
        return (DataType)dataType.notNull();
    }

    private static DataType convertFromColumn(Column column, boolean tinyInt1isBit) {
        String typeName;
        switch (typeName = column.typeName()) {
            case "BIT": {
                return column.length() == 1 ? DataTypes.BOOLEAN() : DataTypes.BINARY((int)((column.length() + 7) / 8));
            }
            case "BOOL": 
            case "BOOLEAN": {
                return DataTypes.BOOLEAN();
            }
            case "TINYINT": {
                return column.length() == 1 && tinyInt1isBit ? DataTypes.BOOLEAN() : DataTypes.TINYINT();
            }
            case "TINYINT UNSIGNED": 
            case "TINYINT UNSIGNED ZEROFILL": 
            case "SMALLINT": {
                return DataTypes.SMALLINT();
            }
            case "SMALLINT UNSIGNED": 
            case "SMALLINT UNSIGNED ZEROFILL": 
            case "INT": 
            case "INTEGER": 
            case "MEDIUMINT": 
            case "YEAR": {
                return DataTypes.INT();
            }
            case "INT UNSIGNED": 
            case "INT UNSIGNED ZEROFILL": 
            case "INTEGER UNSIGNED": 
            case "INTEGER UNSIGNED ZEROFILL": 
            case "MEDIUMINT UNSIGNED": 
            case "MEDIUMINT UNSIGNED ZEROFILL": 
            case "BIGINT": {
                return DataTypes.BIGINT();
            }
            case "BIGINT UNSIGNED": 
            case "BIGINT UNSIGNED ZEROFILL": 
            case "SERIAL": {
                return DataTypes.DECIMAL((int)20, (int)0);
            }
            case "FLOAT": 
            case "FLOAT UNSIGNED": 
            case "FLOAT UNSIGNED ZEROFILL": {
                return DataTypes.FLOAT();
            }
            case "REAL": 
            case "REAL UNSIGNED": 
            case "REAL UNSIGNED ZEROFILL": 
            case "DOUBLE": 
            case "DOUBLE UNSIGNED": 
            case "DOUBLE UNSIGNED ZEROFILL": 
            case "DOUBLE PRECISION": 
            case "DOUBLE PRECISION UNSIGNED": 
            case "DOUBLE PRECISION UNSIGNED ZEROFILL": {
                return DataTypes.DOUBLE();
            }
            case "NUMERIC": 
            case "NUMERIC UNSIGNED": 
            case "NUMERIC UNSIGNED ZEROFILL": 
            case "FIXED": 
            case "FIXED UNSIGNED": 
            case "FIXED UNSIGNED ZEROFILL": 
            case "DECIMAL": 
            case "DECIMAL UNSIGNED": 
            case "DECIMAL UNSIGNED ZEROFILL": {
                return column.length() <= 38 ? DataTypes.DECIMAL((int)column.length(), (int)column.scale().orElse(0)) : DataTypes.STRING();
            }
            case "TIME": {
                return column.length() >= 0 ? DataTypes.TIME((int)column.length()) : DataTypes.TIME();
            }
            case "DATE": {
                return DataTypes.DATE();
            }
            case "DATETIME": {
                return column.length() >= 0 ? DataTypes.TIMESTAMP((int)column.length()) : DataTypes.TIMESTAMP((int)0);
            }
            case "TIMESTAMP": {
                return column.length() >= 0 ? DataTypes.TIMESTAMP_LTZ((int)column.length()) : DataTypes.TIMESTAMP_LTZ((int)0);
            }
            case "CHAR": {
                return DataTypes.CHAR((int)column.length());
            }
            case "VARCHAR": {
                return column.length() == 0 ? DataTypes.STRING() : DataTypes.VARCHAR((int)column.length());
            }
            case "TINYTEXT": 
            case "TEXT": 
            case "MEDIUMTEXT": 
            case "LONGTEXT": 
            case "JSON": 
            case "ENUM": 
            case "GEOMETRY": 
            case "POINT": 
            case "LINESTRING": 
            case "POLYGON": 
            case "GEOMETRYCOLLECTION": 
            case "GEOMCOLLECTION": 
            case "MULTIPOINT": 
            case "MULTIPOLYGON": 
            case "MULTILINESTRING": {
                return DataTypes.STRING();
            }
            case "BINARY": {
                return DataTypes.BINARY((int)column.length());
            }
            case "VARBINARY": {
                return DataTypes.VARBINARY((int)column.length());
            }
            case "TINYBLOB": 
            case "BLOB": 
            case "MEDIUMBLOB": 
            case "LONGBLOB": {
                return DataTypes.BYTES();
            }
            case "SET": {
                return DataTypes.ARRAY((DataType)DataTypes.STRING());
            }
        }
        throw new UnsupportedOperationException(String.format("Don't support MySQL type '%s' yet.", typeName));
    }

    private MySqlTypeUtils() {
    }
}

