/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.mysql.cj.jdbc.Driver;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.mysql.LegacyV1MySqlSourceInfoStructMaker;
import io.debezium.connector.mysql.Module;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlHistoryRecordComparator;
import io.debezium.connector.mysql.MySqlSourceInfoStructMaker;
import io.debezium.function.Predicates;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.KafkaDatabaseHistory;
import io.debezium.util.Collect;
import java.time.Duration;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlConnectorConfig
extends HistorizedRelationalDatabaseConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlConnectorConfig.class);
    static final String TEST_DISABLE_GLOBAL_LOCKING = "test.disable.global.locking";
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = Integer.MIN_VALUE;
    protected static final int DEFAULT_PORT = 3306;
    private static final int DEFAULT_BINLOG_BUFFER_SIZE = 0;
    public static final Field PORT = RelationalDatabaseConnectorConfig.PORT.withDefault(3306);
    public static final Field ON_CONNECT_STATEMENTS = Field.create("database.initial.statements").withDisplayName("Initial statements").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry(Field.Group.CONNECTION_ADVANCED, 4)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDescription("A semicolon separated list of SQL statements to be executed when a JDBC connection (not binlog reading connection) to the database is established. Note that the connector may establish JDBC connections at its own discretion, so this should typically be used for configuration of session parameters only,but not for executing DML statements. Use doubled semicolon (';;') to use a semicolon as a character and not as a delimiter.");
    public static final Field SERVER_NAME = RelationalDatabaseConnectorConfig.SERVER_NAME.withValidation(CommonConnectorConfig::validateServerNameIsDifferentFromHistoryTopicName);
    public static final Field SERVER_ID = Field.create("database.server.id").withDisplayName("Cluster ID").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry(Field.Group.CONNECTION, 1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDefault(MySqlConnectorConfig::randomServerId).required().withValidation(Field::isPositiveLong).withDescription("A numeric ID of this database client, which must be unique across all currently-running database processes in the cluster. This connector joins the MySQL database cluster as another server (with this unique ID) so it can read the binlog. By default, a random number is generated between 5400 and 6400.");
    public static final Field SERVER_ID_OFFSET = Field.create("database.server.id.offset").withDisplayName("Cluster ID offset").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry(Field.Group.CONNECTION_ADVANCED, 0)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDefault(10000L).withDescription("Only relevant if parallel snapshotting is configured. During parallel snapshotting, multiple (4) connections open to the database client, and they each need their own unique connection ID. This offset is used to generate those IDs from the base configured cluster ID.");
    public static final Field SSL_MODE = Field.create("database.ssl.mode").withDisplayName("SSL mode").withEnum(SecureConnectionMode.class, SecureConnectionMode.DISABLED).withGroup(Field.createGroupEntry(Field.Group.CONNECTION_ADVANCED_SSL, 0)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether to use an encrypted connection to MySQL. Options include'disabled' (the default) to use an unencrypted connection; 'preferred' to establish a secure (encrypted) connection if the server supports secure connections, but fall back to an unencrypted connection otherwise; 'required' to use a secure (encrypted) connection, and fail if one cannot be established; 'verify_ca' like 'required' but additionally verify the server TLS certificate against the configured Certificate Authority (CA) certificates, or fail if no valid matching CA certificates are found; or'verify_identity' like 'verify_ca' but additionally verify that the server certificate matches the host to which the connection is attempted.");
    public static final Field SSL_KEYSTORE = Field.create("database.ssl.keystore").withDisplayName("SSL Keystore").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry(Field.Group.CONNECTION_ADVANCED_SSL, 1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The location of the key store file. This is optional and can be used for two-way authentication between the client and the MySQL Server.");
    public static final Field SSL_KEYSTORE_PASSWORD = Field.create("database.ssl.keystore.password").withDisplayName("SSL Keystore Password").withType(ConfigDef.Type.PASSWORD).withGroup(Field.createGroupEntry(Field.Group.CONNECTION_ADVANCED_SSL, 2)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The password for the key store file. This is optional and only needed if 'database.ssl.keystore' is configured.");
    public static final Field SSL_TRUSTSTORE = Field.create("database.ssl.truststore").withDisplayName("SSL Truststore").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry(Field.Group.CONNECTION_ADVANCED_SSL, 3)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The location of the trust store file for the server certificate verification.");
    public static final Field SSL_TRUSTSTORE_PASSWORD = Field.create("database.ssl.truststore.password").withDisplayName("SSL Truststore Password").withType(ConfigDef.Type.PASSWORD).withGroup(Field.createGroupEntry(Field.Group.CONNECTION_ADVANCED_SSL, 4)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The password for the trust store file. Used to check the integrity of the truststore, and unlock the truststore.");
    public static final Field TABLES_IGNORE_BUILTIN = RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN.withDependents("database.include.list");
    public static final Field JDBC_DRIVER = Field.create("database.jdbc.driver").withDisplayName("Jdbc Driver Class Name").withType(ConfigDef.Type.CLASS).withGroup(Field.createGroupEntry(Field.Group.CONNECTION, 41)).withWidth(ConfigDef.Width.MEDIUM).withDefault(Driver.class.getName()).withImportance(ConfigDef.Importance.LOW).withValidation(Field::isClassName).withDescription("JDBC Driver class name used to connect to the MySQL database server.");
    public static final Field GTID_SOURCE_INCLUDES = Field.create("gtid.source.includes").withDisplayName("Include GTID sources").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR, 24)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDependents("table.include.list", "table.whitelist").withDescription("The source UUIDs used to include GTID ranges when determine the starting position in the MySQL server's binlog.");
    public static final Field GTID_SOURCE_EXCLUDES = Field.create("gtid.source.excludes").withDisplayName("Exclude GTID sources").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR, 25)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(MySqlConnectorConfig::validateGtidSetExcludes).withInvisibleRecommender().withDescription("The source UUIDs used to exclude GTID ranges when determine the starting position in the MySQL server's binlog.");
    public static final Field GTID_SOURCE_FILTER_DML_EVENTS = Field.create("gtid.source.filter.dml.events").withDisplayName("Filter DML events").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR, 23)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(true).withDescription("If set to true, we will only produce DML events into Kafka for transactions that were written on mysql servers with UUIDs matching the filters defined by the gtid.source.includes or gtid.source.excludes configuration options, if they are specified.");
    @Deprecated
    public static final Field GTID_NEW_CHANNEL_POSITION = Field.create("gtid.new.channel.position").withDisplayName("GTID start position").withEnum(GtidNewChannelPosition.class, GtidNewChannelPosition.EARLIEST).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withValidation(MySqlConnectorConfig::validateGtidNewChannelPositionNotSet).withDescription("If set to 'latest', when connector sees new GTID, it will start consuming gtid channel from the server latest executed gtid position. If 'earliest' (the default) connector starts reading channel from first available (not purged) gtid position on the server.");
    public static final Field CONNECTION_TIMEOUT_MS = Field.create("connect.timeout.ms").withDisplayName("Connection Timeout (ms)").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry(Field.Group.CONNECTION_ADVANCED, 1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum time to wait after trying to connect to the database before timing out, given in milliseconds. Defaults to 30 seconds (30,000 ms).").withDefault(30000).withValidation(Field::isPositiveInteger);
    public static final Field KEEP_ALIVE = Field.create("connect.keep.alive").withDisplayName("Keep connection alive (true/false)").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry(Field.Group.CONNECTION_ADVANCED, 2)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Whether a separate thread should be used to ensure the connection is kept alive.").withDefault(true).withValidation(Field::isBoolean);
    public static final Field KEEP_ALIVE_INTERVAL_MS = Field.create("connect.keep.alive.interval.ms").withDisplayName("Keep alive interval (ms)").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry(Field.Group.CONNECTION_ADVANCED, 3)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Interval for connection checking if keep alive thread is used, given in milliseconds Defaults to 1 minute (60,000 ms).").withDefault(Duration.ofMinutes(1L).toMillis()).withValidation(Field::isPositiveInteger);
    public static final Field ROW_COUNT_FOR_STREAMING_RESULT_SETS = Field.create("min.row.count.to.stream.results").withDisplayName("Stream result set of size").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_ADVANCED, 2)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("The number of rows a table must contain to stream results rather than pull all into memory during snapshots. Defaults to 1,000. Use 0 to stream all results and completely avoid checking the size of each table.").withDefault(1000).withValidation(Field::isNonNegativeLong);
    public static final Field BUFFER_SIZE_FOR_BINLOG_READER = Field.create("binlog.buffer.size").withDisplayName("Binlog reader buffer size").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_ADVANCED, 3)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The size of a look-ahead buffer used by the  binlog reader to decide whether the transaction in progress is going to be committed or rolled back. Use 0 to disable look-ahead buffering. Defaults to 0 (i.e. buffering is disabled).").withDefault(0).withValidation(Field::isNonNegativeInteger);
    public static final Field DATABASE_HISTORY = Field.create("database.history").withDisplayName("Database history class").withType(ConfigDef.Type.CLASS).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withInvisibleRecommender().withDescription("The name of the DatabaseHistory class that should be used to store and recover database schema changes. The configuration properties for the history are prefixed with the 'database.history.' string.").withDefault(KafkaDatabaseHistory.class.getName());
    public static final Field INCLUDE_SQL_QUERY = Field.create("include.query").withDisplayName("Include original SQL query with in change events").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_ADVANCED, 0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether the connector should include the original SQL query that generated the change event. Note: This option requires MySQL be configured with the binlog_rows_query_log_events option set to ON. Query will not be present for events generated from snapshot. WARNING: Enabling this option may expose tables or fields explicitly blacklisted or masked by including the original SQL statement in the change event. For this reason the default value is 'false'.").withDefault(false);
    public static final Field SNAPSHOT_MODE = Field.create("snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, SnapshotMode.INITIAL).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_SNAPSHOT, 0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'when_needed' to specify that the connector run a snapshot upon startup whenever it deems it necessary; 'schema_only' to only take a snapshot of the schema (table structures) but no actual data; 'initial' (the default) to specify the connector can run a snapshot only when no offsets are available for the logical server name; 'initial_only' same as 'initial' except the connector should stop after completing the snapshot and before it would normally read the binlog; and'never' to specify the connector should never run a snapshot and that upon first startup the connector should read from the beginning of the binlog. The 'never' mode should be used with care, and only when the binlog is known to contain all history.");
    public static final Field SNAPSHOT_LOCKING_MODE = Field.create("snapshot.locking.mode").withDisplayName("Snapshot locking mode").withEnum(SnapshotLockingMode.class, SnapshotLockingMode.MINIMAL).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_SNAPSHOT, 1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls how long the connector holds onto the global read lock while it is performing a snapshot. The default is 'minimal', which means the connector holds the global read lock (and thus prevents any updates) for just the initial portion of the snapshot while the database schemas and other metadata are being read. The remaining work in a snapshot involves selecting all rows from each table, and this can be done using the snapshot process' REPEATABLE READ transaction even when the lock is no longer held and other operations are updating the database. However, in some cases it may be desirable to block all writes for the entire duration of the snapshot; in such cases set this property to 'extended'. Using a value of 'none' will prevent the connector from acquiring any table locks during the snapshot process. This mode can only be used in combination with snapshot.mode values of 'schema_only' or 'schema_only_recovery' and is only safe to use if no schema changes are happening while the snapshot is taken.").withValidation(MySqlConnectorConfig::validateSnapshotLockingMode);
    public static final Field SNAPSHOT_NEW_TABLES = Field.create("snapshot.new.tables").withDisplayName("Snapshot newly added tables").withEnum(SnapshotNewTables.class, SnapshotNewTables.OFF).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_SNAPSHOT, 4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("BETA FEATURE: On connector restart, the connector will check if there have been any new tables added to the configuration, and snapshot them. There is presently only two options:'off': Default behavior. Do not snapshot new tables.'parallel': The snapshot of the new tables will occur in parallel to the continued binlog reading of the old tables. When the snapshot completes, an independent binlog reader will begin reading the events for the new tables until it catches up to present time. At this point, both old and new binlog readers will be momentarily halted and new binlog reader will start that will read the binlog for all configured tables. The parallel binlog reader will have a configured server id of 10000 + the primary binlog reader's server id.");
    public static final Field TIME_PRECISION_MODE = RelationalDatabaseConnectorConfig.TIME_PRECISION_MODE.withEnum(TemporalPrecisionMode.class, TemporalPrecisionMode.ADAPTIVE_TIME_MICROSECONDS).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR, 26)).withValidation(MySqlConnectorConfig::validateTimePrecisionMode).withDescription("Time, date and timestamps can be represented with different kinds of precisions, including:'adaptive_time_microseconds': the precision of date and timestamp values is based the database column's precision; but time fields always use microseconds precision;'connect': always represents time, date and timestamp values using Kafka Connect's built-in representations for Time, Date, and Timestamp, which uses millisecond precision regardless of the database columns' precision.");
    public static final Field BIGINT_UNSIGNED_HANDLING_MODE = Field.create("bigint.unsigned.handling.mode").withDisplayName("BIGINT UNSIGNED Handling").withEnum(BigIntUnsignedHandlingMode.class, BigIntUnsignedHandlingMode.LONG).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR, 27)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify how BIGINT UNSIGNED columns should be represented in change events, including:'precise' uses java.math.BigDecimal to represent values, which are encoded in the change events using a binary representation and Kafka Connect's 'org.apache.kafka.connect.data.Decimal' type; 'long' (the default) represents values using Java's 'long', which may not offer the precision but will be far easier to use in consumers.");
    public static final Field EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE = Field.create("event.deserialization.failure.handling.mode").withDisplayName("Event deserialization failure handling").withEnum(CommonConnectorConfig.EventProcessingFailureHandlingMode.class, CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR, 21)).withValidation(MySqlConnectorConfig::validateEventDeserializationFailureHandlingModeNotSet).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify how failures during deserialization of binlog events (i.e. when encountering a corrupted event) should be handled, including:'fail' (the default) an exception indicating the problematic event and its binlog position is raised, causing the connector to be stopped; 'warn' the problematic event and its binlog position will be logged and the event will be skipped;'ignore' the problematic event will be skipped.");
    public static final Field INCONSISTENT_SCHEMA_HANDLING_MODE = Field.create("inconsistent.schema.handling.mode").withDisplayName("Inconsistent schema failure handling").withEnum(CommonConnectorConfig.EventProcessingFailureHandlingMode.class, CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL).withGroup(Field.createGroupEntry(Field.Group.ADVANCED, 2)).withValidation(MySqlConnectorConfig::validateInconsistentSchemaHandlingModeNotIgnore).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify how binlog events that belong to a table missing from internal schema representation (i.e. internal representation is not consistent with database) should be handled, including:'fail' (the default) an exception indicating the problematic event and its binlog position is raised, causing the connector to be stopped; 'warn' the problematic event and its binlog position will be logged and the event will be skipped;'skip' the problematic event will be skipped.");
    public static final Field ENABLE_TIME_ADJUSTER = Field.create("enable.time.adjuster").withDisplayName("Enable Time Adjuster").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR, 22)).withDefault(true).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("MySQL allows user to insert year value as either 2-digit or 4-digit. In case of two digit the value is automatically mapped into 1970 - 2069.false - delegates the implicit conversion to the databasetrue - (the default) Debezium makes the conversion");
    public static final Field READ_ONLY_CONNECTION = Field.create("read.only").withDisplayName("Read only connection").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Switched connector to use alternative methods to deliver signals to Debezium instead of writing to signaling table");
    private static final ConfigDefinition CONFIG_DEFINITION = HistorizedRelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("MySQL").excluding(SCHEMA_WHITELIST, SCHEMA_INCLUDE_LIST, SCHEMA_BLACKLIST, SCHEMA_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.SERVER_NAME, RelationalDatabaseConnectorConfig.TIME_PRECISION_MODE, RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN).type(HOSTNAME, PORT, USER, PASSWORD, SERVER_NAME, ON_CONNECT_STATEMENTS, SERVER_ID, SERVER_ID_OFFSET, SSL_MODE, SSL_KEYSTORE, SSL_KEYSTORE_PASSWORD, SSL_TRUSTSTORE, SSL_TRUSTSTORE_PASSWORD, JDBC_DRIVER).connector(CONNECTION_TIMEOUT_MS, KEEP_ALIVE, KEEP_ALIVE_INTERVAL_MS, SNAPSHOT_MODE, SNAPSHOT_LOCKING_MODE, SNAPSHOT_NEW_TABLES, BIGINT_UNSIGNED_HANDLING_MODE, TIME_PRECISION_MODE, ENABLE_TIME_ADJUSTER, BINARY_HANDLING_MODE, SCHEMA_NAME_ADJUSTMENT_MODE, ROW_COUNT_FOR_STREAMING_RESULT_SETS, INCREMENTAL_SNAPSHOT_CHUNK_SIZE, INCREMENTAL_SNAPSHOT_ALLOW_SCHEMA_CHANGES).events(INCLUDE_SQL_QUERY, TABLE_IGNORE_BUILTIN, DATABASE_INCLUDE_LIST, DATABASE_EXCLUDE_LIST, GTID_SOURCE_INCLUDES, GTID_SOURCE_EXCLUDES, GTID_SOURCE_FILTER_DML_EVENTS, BUFFER_SIZE_FOR_BINLOG_READER, EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE, INCONSISTENT_SCHEMA_HANDLING_MODE).create();
    public static Field.Set ALL_FIELDS;
    protected static Field.Set EXPOSED_FIELDS;
    protected static final Set<String> BUILT_IN_DB_NAMES;
    private final Configuration config;
    private final SnapshotMode snapshotMode;
    private final SnapshotLockingMode snapshotLockingMode;
    private final GtidNewChannelPosition gitIdNewChannelPosition;
    private final SnapshotNewTables snapshotNewTables;
    private final TemporalPrecisionMode temporalPrecisionMode;
    private final Duration connectionTimeout;
    private final Predicate<String> gtidSourceFilter;
    private final CommonConnectorConfig.EventProcessingFailureHandlingMode inconsistentSchemaFailureHandlingMode;
    private final Predicate<String> ddlFilter;
    private final boolean legacy;
    private final SourceInfoStructMaker<? extends AbstractSourceInfo> sourceInfoStructMaker;
    private final boolean readOnlyConnection;

    protected static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    @Override
    public boolean supportsOperationFiltering() {
        return true;
    }

    @Override
    protected boolean supportsSchemaChangesDuringIncrementalSnapshot() {
        return true;
    }

    public MySqlConnectorConfig(Configuration config) {
        super(MySqlConnector.class, config, config.getString(SERVER_NAME), Tables.TableFilter.fromPredicate(MySqlConnectorConfig::isNotBuiltInTable), true, Integer.MIN_VALUE, ColumnFilterMode.CATALOG, false);
        this.config = config;
        this.legacy = MySqlConnector.isLegacy(config.getString("internal.implementation"));
        this.temporalPrecisionMode = TemporalPrecisionMode.parse(config.getString(TIME_PRECISION_MODE));
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE), SNAPSHOT_MODE.defaultValueAsString());
        this.snapshotLockingMode = SnapshotLockingMode.parse(config.getString(SNAPSHOT_LOCKING_MODE), SNAPSHOT_LOCKING_MODE.defaultValueAsString());
        this.readOnlyConnection = config.getBoolean(READ_ONLY_CONNECTION);
        String gitIdNewChannelPosition = config.getString(GTID_NEW_CHANNEL_POSITION);
        this.gitIdNewChannelPosition = GtidNewChannelPosition.parse(gitIdNewChannelPosition, GTID_NEW_CHANNEL_POSITION.defaultValueAsString());
        String snapshotNewTables = config.getString(SNAPSHOT_NEW_TABLES);
        this.snapshotNewTables = SnapshotNewTables.parse(snapshotNewTables, SNAPSHOT_NEW_TABLES.defaultValueAsString());
        String inconsistentSchemaFailureHandlingMode = config.getString(INCONSISTENT_SCHEMA_HANDLING_MODE);
        this.inconsistentSchemaFailureHandlingMode = CommonConnectorConfig.EventProcessingFailureHandlingMode.parse(inconsistentSchemaFailureHandlingMode);
        this.connectionTimeout = Duration.ofMillis(config.getLong(CONNECTION_TIMEOUT_MS));
        String gtidSetIncludes = config.getString(GTID_SOURCE_INCLUDES);
        String gtidSetExcludes = config.getString(GTID_SOURCE_EXCLUDES);
        this.gtidSourceFilter = gtidSetIncludes != null ? Predicates.includesUuids(gtidSetIncludes) : (gtidSetExcludes != null ? Predicates.excludesUuids(gtidSetExcludes) : null);
        String ddlFilter = config.getString(DatabaseHistory.DDL_FILTER);
        this.ddlFilter = ddlFilter != null ? Predicates.includes(ddlFilter) : x -> false;
        this.sourceInfoStructMaker = this.getSourceInfoStructMaker(CommonConnectorConfig.Version.parse(config.getString(SOURCE_STRUCT_MAKER_VERSION)));
    }

    public boolean useCursorFetch() {
        return this.getSnapshotFetchSize() > 0;
    }

    public SnapshotLockingMode getSnapshotLockingMode() {
        return this.snapshotLockingMode;
    }

    public GtidNewChannelPosition gtidNewChannelPosition() {
        return this.gitIdNewChannelPosition;
    }

    public SnapshotNewTables getSnapshotNewTables() {
        return this.snapshotNewTables;
    }

    private static int validateGtidNewChannelPositionNotSet(Configuration config, Field field, Field.ValidationOutput problems) {
        if (config.getString(GTID_NEW_CHANNEL_POSITION.name()) != null) {
            LOGGER.warn("Configuration option '{}' is deprecated and scheduled for removal", (Object)GTID_NEW_CHANNEL_POSITION.name());
        }
        return 0;
    }

    private static int validateEventDeserializationFailureHandlingModeNotSet(Configuration config, Field field, Field.ValidationOutput problems) {
        String modeName = config.asMap().get(EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE.name());
        if (modeName != null) {
            LOGGER.warn("Configuration option '{}' is renamed to '{}'", (Object)EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE.name(), (Object)EVENT_PROCESSING_FAILURE_HANDLING_MODE.name());
            if ("ignore".equals(modeName)) {
                LOGGER.warn("Value '{}' of configuration option '{}' is deprecated and should be replaced with '{}'", new Object[]{"ignore", EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE.name(), CommonConnectorConfig.EventProcessingFailureHandlingMode.SKIP.getValue()});
            }
        }
        return 0;
    }

    private static int validateInconsistentSchemaHandlingModeNotIgnore(Configuration config, Field field, Field.ValidationOutput problems) {
        String modeName = config.getString(INCONSISTENT_SCHEMA_HANDLING_MODE);
        if ("ignore".equals(modeName)) {
            LOGGER.warn("Value '{}' of configuration option '{}' is deprecated and should be replaced with '{}'", new Object[]{"ignore", INCONSISTENT_SCHEMA_HANDLING_MODE.name(), CommonConnectorConfig.EventProcessingFailureHandlingMode.SKIP.getValue()});
        }
        return 0;
    }

    private static int validateGtidSetExcludes(Configuration config, Field field, Field.ValidationOutput problems) {
        String includes = config.getString(GTID_SOURCE_INCLUDES);
        String excludes = config.getString(GTID_SOURCE_EXCLUDES);
        if (includes != null && excludes != null) {
            problems.accept(GTID_SOURCE_EXCLUDES, excludes, "Included GTID source UUIDs are already specified");
            return 1;
        }
        return 0;
    }

    private static int validateSnapshotLockingMode(Configuration config, Field field, Field.ValidationOutput problems) {
        SnapshotLockingMode lockingModeValue;
        if (config.hasKey(SNAPSHOT_LOCKING_MODE.name()) && (lockingModeValue = SnapshotLockingMode.parse(config.getString(SNAPSHOT_LOCKING_MODE))) == null) {
            problems.accept(SNAPSHOT_LOCKING_MODE, lockingModeValue, "Must be a valid snapshot.locking.mode value");
            return 1;
        }
        return 0;
    }

    private static int validateTimePrecisionMode(Configuration config, Field field, Field.ValidationOutput problems) {
        if (config.hasKey(TIME_PRECISION_MODE.name())) {
            String timePrecisionMode = config.getString(TIME_PRECISION_MODE.name());
            if (TemporalPrecisionMode.ADAPTIVE.getValue().equals(timePrecisionMode)) {
                problems.accept(TIME_PRECISION_MODE, timePrecisionMode, "The 'adaptive' time.precision.mode is no longer supported");
                return 1;
            }
        }
        return 0;
    }

    private static int randomServerId() {
        int lowestServerId = 5400;
        int highestServerId = 6400;
        return lowestServerId + new Random().nextInt(highestServerId - lowestServerId);
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        switch (version) {
            case V1: {
                return this.legacy ? new io.debezium.connector.mysql.legacy.LegacyV1MySqlSourceInfoStructMaker(Module.name(), Module.version(), this) : new LegacyV1MySqlSourceInfoStructMaker(Module.name(), Module.version(), this);
            }
        }
        return this.legacy ? new io.debezium.connector.mysql.legacy.MySqlSourceInfoStructMaker(Module.name(), Module.version(), this) : new MySqlSourceInfoStructMaker(Module.name(), Module.version(), this);
    }

    @Override
    public String getContextName() {
        return Module.contextName();
    }

    @Override
    public String getConnectorName() {
        return Module.name();
    }

    @Override
    public TemporalPrecisionMode getTemporalPrecisionMode() {
        return this.temporalPrecisionMode;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public CommonConnectorConfig.EventProcessingFailureHandlingMode inconsistentSchemaFailureHandlingMode() {
        return this.inconsistentSchemaFailureHandlingMode;
    }

    public String hostname() {
        return this.config.getString(HOSTNAME);
    }

    public int port() {
        return this.config.getInteger(PORT);
    }

    public String username() {
        return this.config.getString(USER);
    }

    public String password() {
        return this.config.getString(PASSWORD);
    }

    public long serverId() {
        return this.config.getLong(SERVER_ID);
    }

    public SecureConnectionMode sslMode() {
        String mode = this.config.getString(SSL_MODE);
        return SecureConnectionMode.parse(mode);
    }

    public boolean sslModeEnabled() {
        return this.sslMode() != SecureConnectionMode.DISABLED;
    }

    public int bufferSizeForStreamingChangeEventSource() {
        return this.config.getInteger(BUFFER_SIZE_FOR_BINLOG_READER);
    }

    public Predicate<String> gtidSourceFilter() {
        return this.gtidSourceFilter;
    }

    public boolean includeSchemaChangeRecords() {
        return this.config.getBoolean(INCLUDE_SCHEMA_CHANGES);
    }

    public boolean includeSqlQuery() {
        return this.config.getBoolean(INCLUDE_SQL_QUERY);
    }

    public long rowCountForLargeTable() {
        return this.config.getLong(ROW_COUNT_FOR_STREAMING_RESULT_SETS);
    }

    @Override
    protected HistoryRecordComparator getHistoryRecordComparator() {
        return new MySqlHistoryRecordComparator(this.gtidSourceFilter());
    }

    public static boolean isBuiltInDatabase(String databaseName) {
        if (databaseName == null) {
            return false;
        }
        return BUILT_IN_DB_NAMES.contains(databaseName.toLowerCase());
    }

    public static boolean isNotBuiltInTable(TableId id) {
        return !MySqlConnectorConfig.isBuiltInDatabase(id.catalog());
    }

    public Predicate<String> getDdlFilter() {
        return this.ddlFilter;
    }

    boolean legacy() {
        return this.legacy;
    }

    public boolean isReadOnlyConnection() {
        return this.readOnlyConnection;
    }

    boolean useGlobalLock() {
        return !"true".equals(this.config.getString(TEST_DISABLE_GLOBAL_LOCKING));
    }

    public SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker() {
        return this.sourceInfoStructMaker;
    }

    static {
        EXPOSED_FIELDS = ALL_FIELDS = Field.setOf(CONFIG_DEFINITION.all());
        BUILT_IN_DB_NAMES = Collect.unmodifiableSet("mysql", "performance_schema", "sys", "information_schema");
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        WHEN_NEEDED("when_needed", true, true, true, false, true),
        INITIAL("initial", true, true, true, false, false),
        SCHEMA_ONLY("schema_only", true, false, true, false, false),
        SCHEMA_ONLY_RECOVERY("schema_only_recovery", true, false, true, true, false),
        NEVER("never", false, false, true, false, false),
        INITIAL_ONLY("initial_only", true, true, false, false, false);

        private final String value;
        private final boolean includeSchema;
        private final boolean includeData;
        private final boolean shouldStream;
        private final boolean shouldSnapshotOnSchemaError;
        private final boolean shouldSnapshotOnDataError;

        private SnapshotMode(String value, boolean includeSchema, boolean includeData, boolean shouldStream, boolean shouldSnapshotOnSchemaError, boolean shouldSnapshotOnDataError) {
            this.value = value;
            this.includeSchema = includeSchema;
            this.includeData = includeData;
            this.shouldStream = shouldStream;
            this.shouldSnapshotOnSchemaError = shouldSnapshotOnSchemaError;
            this.shouldSnapshotOnDataError = shouldSnapshotOnDataError;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean includeSchema() {
            return this.includeSchema;
        }

        public boolean includeData() {
            return this.includeData;
        }

        public boolean shouldStream() {
            return this.shouldStream;
        }

        public boolean shouldSnapshotOnSchemaError() {
            return this.shouldSnapshotOnSchemaError;
        }

        public boolean shouldSnapshotOnDataError() {
            return this.shouldSnapshotOnDataError;
        }

        public boolean shouldSnapshot() {
            return this.includeSchema || this.includeData;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotLockingMode implements EnumeratedValue
    {
        EXTENDED("extended"),
        MINIMAL("minimal"),
        MINIMAL_PERCONA("minimal_percona"),
        NONE("none");

        private final String value;

        private SnapshotLockingMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean usesMinimalLocking() {
            return this.value.equals(SnapshotLockingMode.MINIMAL.value) || this.value.equals(SnapshotLockingMode.MINIMAL_PERCONA.value);
        }

        public boolean usesLocking() {
            return !this.value.equals(SnapshotLockingMode.NONE.value);
        }

        public boolean flushResetsIsolationLevel() {
            return !this.value.equals(SnapshotLockingMode.MINIMAL_PERCONA.value);
        }

        public String getLockStatement() {
            if (this.value.equals(SnapshotLockingMode.MINIMAL_PERCONA.value)) {
                return "LOCK TABLES FOR BACKUP";
            }
            return "FLUSH TABLES WITH READ LOCK";
        }

        public static SnapshotLockingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotLockingMode option : SnapshotLockingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotLockingMode parse(String value, String defaultValue) {
            SnapshotLockingMode mode = SnapshotLockingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotLockingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum GtidNewChannelPosition implements EnumeratedValue
    {
        LATEST("latest"),
        EARLIEST("earliest");

        private final String value;

        private GtidNewChannelPosition(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static GtidNewChannelPosition parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (GtidNewChannelPosition option : GtidNewChannelPosition.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static GtidNewChannelPosition parse(String value, String defaultValue) {
            GtidNewChannelPosition mode = GtidNewChannelPosition.parse(value);
            if (mode == null && defaultValue != null) {
                mode = GtidNewChannelPosition.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotNewTables implements EnumeratedValue
    {
        OFF("off"),
        PARALLEL("parallel");

        private final String value;

        private SnapshotNewTables(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static SnapshotNewTables parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotNewTables option : SnapshotNewTables.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotNewTables parse(String value, String defaultValue) {
            SnapshotNewTables snapshotNewTables = SnapshotNewTables.parse(value);
            if (snapshotNewTables == null && defaultValue != null) {
                snapshotNewTables = SnapshotNewTables.parse(defaultValue);
            }
            return snapshotNewTables;
        }
    }

    public static enum SecureConnectionMode implements EnumeratedValue
    {
        DISABLED("disabled"),
        PREFERRED("preferred"),
        REQUIRED("required"),
        VERIFY_CA("verify_ca"),
        VERIFY_IDENTITY("verify_identity");

        private final String value;

        private SecureConnectionMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static SecureConnectionMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SecureConnectionMode option : SecureConnectionMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SecureConnectionMode parse(String value, String defaultValue) {
            SecureConnectionMode mode = SecureConnectionMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SecureConnectionMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum BigIntUnsignedHandlingMode implements EnumeratedValue
    {
        PRECISE("precise"),
        LONG("long");

        private final String value;

        private BigIntUnsignedHandlingMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public JdbcValueConverters.BigIntUnsignedMode asBigIntUnsignedMode() {
            switch (this) {
                case LONG: {
                    return JdbcValueConverters.BigIntUnsignedMode.LONG;
                }
            }
            return JdbcValueConverters.BigIntUnsignedMode.PRECISE;
        }

        public static BigIntUnsignedHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (BigIntUnsignedHandlingMode option : BigIntUnsignedHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static BigIntUnsignedHandlingMode parse(String value, String defaultValue) {
            BigIntUnsignedHandlingMode mode = BigIntUnsignedHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = BigIntUnsignedHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

