/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.serde.json;

import io.debezium.common.annotation.Incubating;
import io.debezium.serde.json.JsonSerdeConfig;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.serialization.Deserializer;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.serialization.Serde;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.serialization.Serializer;

@Incubating
public class JsonSerde<T>
implements Serde<T> {
    private static final String PAYLOAD_FIELD = "payload";
    private final ObjectMapper mapper = new ObjectMapper();
    private ObjectReader reader;
    private boolean isKey;
    private JsonSerdeConfig config;

    public JsonSerde(Class<T> objectType) {
        this.mapper.registerModule(new JavaTimeModule());
        this.reader = this.mapper.readerFor(objectType);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.config = new JsonSerdeConfig(configs);
        if (this.config.isUnknownPropertiesIgnored() && this.mapper.getDeserializationConfig().isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.reader = this.reader.without(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Serializer<T> serializer() {
        return new JsonSerializer();
    }

    @Override
    public Deserializer<T> deserializer() {
        return new JsonDeserializer();
    }

    private final class JsonSerializer
    implements Serializer<T> {
        private JsonSerializer() {
        }

        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        @Override
        public byte[] serialize(String topic, T data) {
            try {
                return JsonSerde.this.mapper.writeValueAsBytes(data);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
        }
    }

    private final class JsonDeserializer
    implements Deserializer<T> {
        private JsonDeserializer() {
        }

        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        @Override
        public T deserialize(String topic, byte[] data) {
            if (data == null) {
                return null;
            }
            try {
                JsonNode node = JsonSerde.this.mapper.readTree(data);
                return JsonSerde.this.isKey ? this.readKey(node) : this.readValue(node);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private T readValue(JsonNode node) throws IOException {
            JsonNode payload = node.get(JsonSerde.PAYLOAD_FIELD);
            if (payload != null) {
                node = payload;
            }
            if (JsonSerde.this.config.asEnvelope()) {
                return JsonSerde.this.reader.readValue(node);
            }
            if (node.has("source") && node.has(JsonSerde.this.config.sourceField())) {
                return JsonSerde.this.reader.readValue(node.get(JsonSerde.this.config.sourceField()));
            }
            return JsonSerde.this.reader.readValue(node);
        }

        private T readKey(JsonNode node) throws IOException {
            if (!node.isObject()) {
                return JsonSerde.this.reader.readValue(node);
            }
            JsonNode keys = node.has(JsonSerde.PAYLOAD_FIELD) ? node.get(JsonSerde.PAYLOAD_FIELD) : node;
            Iterator<String> keyFields = keys.fieldNames();
            if (keyFields.hasNext()) {
                String id = keyFields.next();
                if (!keyFields.hasNext()) {
                    return JsonSerde.this.reader.readValue(keys.get(id));
                }
                return JsonSerde.this.reader.readValue(keys);
            }
            return JsonSerde.this.reader.readValue(keys);
        }

        @Override
        public void close() {
        }
    }
}

