/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.legacy;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.legacy.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ChainedReader
implements Reader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<Reader> readers;
    private final String completionMessage;
    private final LinkedList<Reader> remainingReaders = new LinkedList();
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicBoolean completed = new AtomicBoolean(true);
    private final AtomicReference<Reader> currentReader = new AtomicReference();
    private final AtomicReference<Consumer<MySqlPartition>> uponCompletion = new AtomicReference();

    private ChainedReader(List<Reader> readers, String completionMessage) {
        this.readers = Collections.unmodifiableList(readers);
        this.completionMessage = completionMessage;
        for (Reader reader : this.readers) {
            reader.uponCompletion(this::readerCompletedPolling);
        }
    }

    @Override
    public void uponCompletion(Consumer<MySqlPartition> handler) {
        this.uponCompletion.set(handler);
    }

    @Override
    public void initialize() {
        this.readers.forEach(Reader::initialize);
    }

    @Override
    public void destroy() {
        this.readers.forEach(Reader::destroy);
    }

    @Override
    public synchronized void start(MySqlPartition partition) {
        if (this.running.compareAndSet(false, true)) {
            this.completed.set(false);
            this.remainingReaders.clear();
            this.readers.forEach(this.remainingReaders::add);
            if (!this.startNextReader(partition)) {
                this.running.set(false);
                this.completed.set(true);
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.remainingReaders.clear();
            Reader current = this.currentReader.get();
            if (current != null) {
                try {
                    this.logger.info("ChainedReader: Stopping the {} reader", (Object)current.name());
                    current.stop();
                }
                catch (Throwable t) {
                    this.logger.error("Unexpected error stopping the {} reader", (Object)current.name(), (Object)t);
                }
            }
        }
    }

    @Override
    public Reader.State state() {
        if (this.running.get()) {
            return Reader.State.RUNNING;
        }
        return this.completed.get() ? Reader.State.STOPPED : Reader.State.STOPPING;
    }

    @Override
    public List<SourceRecord> poll() throws InterruptedException {
        Reader reader;
        if ((this.running.get() || !this.completed.get()) && (reader = this.currentReader.get()) != null) {
            return reader.poll();
        }
        return null;
    }

    private synchronized void readerCompletedPolling(MySqlPartition partition) {
        if (!this.startNextReader(partition)) {
            try {
                if (this.running.get() || !this.completed.get()) {
                    Consumer<MySqlPartition> handler = this.uponCompletion.get();
                    if (handler != null) {
                        handler.accept(partition);
                    }
                    if (this.completionMessage != null) {
                        this.logger.info(this.completionMessage);
                    }
                }
            }
            finally {
                this.completed.set(true);
                this.running.set(false);
            }
        }
    }

    private boolean startNextReader(MySqlPartition partition) {
        Reader reader;
        Reader reader2 = reader = this.remainingReaders.isEmpty() ? null : this.remainingReaders.pop();
        if (reader == null) {
            Reader lastReader = this.currentReader.getAndSet(null);
            if (lastReader != null) {
                lastReader.stop();
            }
            return false;
        }
        Reader lastReader = this.currentReader.getAndSet(null);
        if (lastReader != null) {
            this.logger.info("Transitioning from the {} reader to the {} reader", (Object)lastReader.name(), (Object)reader.name());
        } else {
            this.logger.debug("Starting the {} reader", (Object)reader.name());
        }
        reader.start(partition);
        this.currentReader.set(reader);
        return true;
    }

    @Override
    public String name() {
        Reader reader = this.currentReader.get();
        return reader != null ? reader.name() : "chained";
    }

    public static class Builder {
        private final List<Reader> readers = new ArrayList<Reader>();
        private String completionMessage;

        public Builder addReader(Reader reader) {
            this.readers.add(reader);
            return this;
        }

        public Builder completionMessage(String message) {
            this.completionMessage = message;
            return this;
        }

        public ChainedReader build() {
            return new ChainedReader(this.readers, this.completionMessage);
        }
    }
}

