/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.split;

import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffset;
import org.apache.flink.cdc.connectors.mysql.source.split.FinishedSnapshotSplitInfo;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlBinlogSplit
extends MySqlSplit {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlBinlogSplit.class);
    private final BinlogOffset startingOffset;
    private final BinlogOffset endingOffset;
    private final List<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos;
    private final Map<TableId, TableChanges.TableChange> tableSchemas;
    private final int totalFinishedSplitSize;
    private final boolean isSuspended;
    @Nullable
    transient byte[] serializedFormCache;

    public MySqlBinlogSplit(String splitId, BinlogOffset startingOffset, BinlogOffset endingOffset, List<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos, Map<TableId, TableChanges.TableChange> tableSchemas, int totalFinishedSplitSize, boolean isSuspended) {
        super(splitId);
        this.startingOffset = startingOffset;
        this.endingOffset = endingOffset;
        this.finishedSnapshotSplitInfos = finishedSnapshotSplitInfos;
        this.tableSchemas = tableSchemas;
        this.totalFinishedSplitSize = totalFinishedSplitSize;
        this.isSuspended = isSuspended;
    }

    public MySqlBinlogSplit(String splitId, BinlogOffset startingOffset, BinlogOffset endingOffset, List<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos, Map<TableId, TableChanges.TableChange> tableSchemas, int totalFinishedSplitSize) {
        super(splitId);
        this.startingOffset = startingOffset;
        this.endingOffset = endingOffset;
        this.finishedSnapshotSplitInfos = finishedSnapshotSplitInfos;
        this.tableSchemas = tableSchemas;
        this.totalFinishedSplitSize = totalFinishedSplitSize;
        this.isSuspended = false;
    }

    public BinlogOffset getStartingOffset() {
        return this.startingOffset;
    }

    public BinlogOffset getEndingOffset() {
        return this.endingOffset;
    }

    public List<FinishedSnapshotSplitInfo> getFinishedSnapshotSplitInfos() {
        return this.finishedSnapshotSplitInfos;
    }

    @Override
    public Map<TableId, TableChanges.TableChange> getTableSchemas() {
        return this.tableSchemas;
    }

    public int getTotalFinishedSplitSize() {
        return this.totalFinishedSplitSize;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public boolean isCompletedSplit() {
        return this.totalFinishedSplitSize == this.finishedSnapshotSplitInfos.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlBinlogSplit)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MySqlBinlogSplit that = (MySqlBinlogSplit)o;
        return this.totalFinishedSplitSize == that.totalFinishedSplitSize && this.isSuspended == that.isSuspended && Objects.equals(this.startingOffset, that.startingOffset) && Objects.equals(this.endingOffset, that.endingOffset) && Objects.equals(this.finishedSnapshotSplitInfos, that.finishedSnapshotSplitInfos) && Objects.equals(this.tableSchemas, that.tableSchemas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startingOffset, this.endingOffset, this.finishedSnapshotSplitInfos, this.tableSchemas, this.totalFinishedSplitSize, this.isSuspended);
    }

    public String toString() {
        return "MySqlBinlogSplit{splitId='" + this.splitId + '\'' + ", offset=" + this.startingOffset + ", endOffset=" + this.endingOffset + ", isSuspended=" + this.isSuspended + '}';
    }

    public static MySqlBinlogSplit appendFinishedSplitInfos(MySqlBinlogSplit binlogSplit, List<FinishedSnapshotSplitInfo> splitInfos) {
        BinlogOffset startingOffset = binlogSplit.getStartingOffset();
        for (FinishedSnapshotSplitInfo splitInfo : splitInfos) {
            if (!splitInfo.getHighWatermark().isBefore(startingOffset)) continue;
            startingOffset = splitInfo.getHighWatermark();
        }
        splitInfos.addAll(binlogSplit.getFinishedSnapshotSplitInfos());
        return new MySqlBinlogSplit(binlogSplit.splitId, startingOffset, binlogSplit.getEndingOffset(), splitInfos, binlogSplit.getTableSchemas(), binlogSplit.getTotalFinishedSplitSize(), binlogSplit.isSuspended());
    }

    public static MySqlBinlogSplit filterOutdatedSplitInfos(MySqlBinlogSplit binlogSplit, Tables.TableFilter currentTableFilter) {
        Map<TableId, TableChanges.TableChange> filteredTableSchemas = binlogSplit.getTableSchemas().entrySet().stream().filter(entry -> currentTableFilter.isIncluded((TableId)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Set tablesToRemoveInFinishedSnapshotSplitInfos = binlogSplit.getFinishedSnapshotSplitInfos().stream().filter(i -> !currentTableFilter.isIncluded(i.getTableId())).map(split -> split.getTableId()).collect(Collectors.toSet());
        if (tablesToRemoveInFinishedSnapshotSplitInfos.isEmpty()) {
            return new MySqlBinlogSplit(binlogSplit.splitId, binlogSplit.getStartingOffset(), binlogSplit.getEndingOffset(), binlogSplit.getFinishedSnapshotSplitInfos(), filteredTableSchemas, binlogSplit.totalFinishedSplitSize, binlogSplit.isSuspended());
        }
        LOG.info("Reader remove tables after restart: {}", tablesToRemoveInFinishedSnapshotSplitInfos);
        List<FinishedSnapshotSplitInfo> allFinishedSnapshotSplitInfos = binlogSplit.getFinishedSnapshotSplitInfos().stream().filter(i -> !tablesToRemoveInFinishedSnapshotSplitInfos.contains(i.getTableId())).collect(Collectors.toList());
        return new MySqlBinlogSplit(binlogSplit.splitId, binlogSplit.getStartingOffset(), binlogSplit.getEndingOffset(), allFinishedSnapshotSplitInfos, filteredTableSchemas, binlogSplit.getTotalFinishedSplitSize() - (binlogSplit.getFinishedSnapshotSplitInfos().size() - allFinishedSnapshotSplitInfos.size()), binlogSplit.isSuspended());
    }

    public static MySqlBinlogSplit fillTableSchemas(MySqlBinlogSplit binlogSplit, Map<TableId, TableChanges.TableChange> tableSchemas) {
        tableSchemas.putAll(binlogSplit.getTableSchemas());
        return new MySqlBinlogSplit(binlogSplit.splitId, binlogSplit.getStartingOffset(), binlogSplit.getEndingOffset(), binlogSplit.getFinishedSnapshotSplitInfos(), tableSchemas, binlogSplit.getTotalFinishedSplitSize(), binlogSplit.isSuspended());
    }

    public static MySqlBinlogSplit toNormalBinlogSplit(MySqlBinlogSplit suspendedBinlogSplit, int totalFinishedSplitSize) {
        return new MySqlBinlogSplit(suspendedBinlogSplit.splitId, suspendedBinlogSplit.getStartingOffset(), suspendedBinlogSplit.getEndingOffset(), suspendedBinlogSplit.getFinishedSnapshotSplitInfos(), suspendedBinlogSplit.getTableSchemas(), totalFinishedSplitSize, false);
    }

    public static MySqlBinlogSplit toSuspendedBinlogSplit(MySqlBinlogSplit normalBinlogSplit) {
        return new MySqlBinlogSplit(normalBinlogSplit.splitId, normalBinlogSplit.getStartingOffset(), normalBinlogSplit.getEndingOffset(), MySqlBinlogSplit.forwardHighWatermarkToStartingOffset(normalBinlogSplit.getFinishedSnapshotSplitInfos(), normalBinlogSplit.getStartingOffset()), normalBinlogSplit.getTableSchemas(), normalBinlogSplit.getTotalFinishedSplitSize(), true);
    }

    private static List<FinishedSnapshotSplitInfo> forwardHighWatermarkToStartingOffset(List<FinishedSnapshotSplitInfo> existedSplitInfos, BinlogOffset currentBinlogReadingOffset) {
        ArrayList<FinishedSnapshotSplitInfo> updatedSnapshotSplitInfos = new ArrayList<FinishedSnapshotSplitInfo>();
        for (FinishedSnapshotSplitInfo existedSplitInfo : existedSplitInfos) {
            if (existedSplitInfo.getHighWatermark().isBefore(currentBinlogReadingOffset)) {
                FinishedSnapshotSplitInfo forwardHighWatermarkSnapshotSplitInfo = new FinishedSnapshotSplitInfo(existedSplitInfo.getTableId(), existedSplitInfo.getSplitId(), existedSplitInfo.getSplitStart(), existedSplitInfo.getSplitEnd(), currentBinlogReadingOffset);
                updatedSnapshotSplitInfos.add(forwardHighWatermarkSnapshotSplitInfo);
                continue;
            }
            updatedSnapshotSplitInfos.add(existedSplitInfo);
        }
        return updatedSnapshotSplitInfos;
    }
}

