/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.record;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.network.TransferableChannel;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.record.UnalignedRecords;

public class UnalignedFileRecords
implements UnalignedRecords {
    private final FileChannel channel;
    private final long position;
    private final int size;

    public UnalignedFileRecords(FileChannel channel, long position, int size) {
        this.channel = channel;
        this.position = position;
        this.size = size;
    }

    @Override
    public int sizeInBytes() {
        return this.size;
    }

    @Override
    public long writeTo(TransferableChannel destChannel, long previouslyWritten, int remaining) throws IOException {
        long position = this.position + previouslyWritten;
        long count = Math.min((long)remaining, (long)this.sizeInBytes() - previouslyWritten);
        return destChannel.transferFrom(this.channel, position, count);
    }
}

