/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.data.binary;

import java.nio.ByteOrder;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.data.ArrayData;
import org.apache.flink.cdc.common.data.DateData;
import org.apache.flink.cdc.common.data.DecimalData;
import org.apache.flink.cdc.common.data.LocalZonedTimestampData;
import org.apache.flink.cdc.common.data.MapData;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.data.StringData;
import org.apache.flink.cdc.common.data.TimeData;
import org.apache.flink.cdc.common.data.TimestampData;
import org.apache.flink.cdc.common.data.ZonedTimestampData;
import org.apache.flink.cdc.common.data.binary.BinarySection;
import org.apache.flink.cdc.common.data.binary.BinarySegmentUtils;
import org.apache.flink.cdc.common.data.binary.NullAwareGetters;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.core.memory.MemorySegmentFactory;

@Internal
public final class BinaryRecordData
extends BinarySection
implements RecordData,
NullAwareGetters {
    public static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final long FIRST_BYTE_ZERO = LITTLE_ENDIAN ? -256L : 0xFFFFFFFFFFFFFFL;
    public static final int HEADER_SIZE_IN_BITS = 8;
    public static final String TIMESTAMP_DELIMITER = "//";
    private final int arity;
    private final int nullBitsSizeInBytes;

    public static int calculateBitSetWidthInBytes(int arity) {
        return (arity + 63 + 8) / 64 * 8;
    }

    public BinaryRecordData(int arity) {
        Preconditions.checkArgument(arity >= 0);
        this.arity = arity;
        this.nullBitsSizeInBytes = BinaryRecordData.calculateBitSetWidthInBytes(arity);
    }

    private int getFieldOffset(int pos) {
        return this.offset + this.nullBitsSizeInBytes + pos * 8;
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.arity) : "index (" + index + ") should < " + this.arity;
    }

    public int getFixedLengthPartSize() {
        return this.nullBitsSizeInBytes + 8 * this.arity;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public boolean isNullAt(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.bitGet(this.segments[0], this.offset, pos + 8);
    }

    @Override
    public boolean getBoolean(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getBoolean(this.getFieldOffset(pos));
    }

    @Override
    public byte getByte(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].get(this.getFieldOffset(pos));
    }

    @Override
    public short getShort(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getShort(this.getFieldOffset(pos));
    }

    @Override
    public int getInt(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getInt(this.getFieldOffset(pos));
    }

    @Override
    public long getLong(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getLong(this.getFieldOffset(pos));
    }

    @Override
    public float getFloat(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getFloat(this.getFieldOffset(pos));
    }

    @Override
    public double getDouble(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getDouble(this.getFieldOffset(pos));
    }

    @Override
    public StringData getString(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = this.segments[0].getLong(fieldOffset);
        return BinarySegmentUtils.readStringData(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (DecimalData.isCompact(precision)) {
            return DecimalData.fromUnscaledLong(this.segments[0].getLong(this.getFieldOffset(pos)), precision, scale);
        }
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndSize = this.segments[0].getLong(fieldOffset);
        return BinarySegmentUtils.readDecimalData(this.segments, this.offset, offsetAndSize, precision, scale);
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndNanoOfMilli = this.segments[0].getLong(fieldOffset);
        return BinarySegmentUtils.readTimestampData(this.segments, this.offset, offsetAndNanoOfMilli);
    }

    @Override
    public ZonedTimestampData getZonedTimestamp(int pos, int precision) {
        String[] parts = this.getString(pos).toString().split(TIMESTAMP_DELIMITER);
        return ZonedTimestampData.of(Long.parseLong(parts[0]), Integer.parseInt(parts[1]), parts[2]);
    }

    @Override
    public LocalZonedTimestampData getLocalZonedTimestampData(int pos, int precision) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndNanoOfMilli = this.segments[0].getLong(fieldOffset);
        return BinarySegmentUtils.readLocalZonedTimestampData(this.segments, this.offset, offsetAndNanoOfMilli);
    }

    @Override
    public byte[] getBinary(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = this.segments[0].getLong(fieldOffset);
        return BinarySegmentUtils.readBinary(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public ArrayData getArray(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.readArrayData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public MapData getMap(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.readMapData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public RecordData getRow(int pos, int numFields) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.readRecordData(this.segments, numFields, this.offset, this.getLong(pos));
    }

    @Override
    public DateData getDate(int pos) {
        this.assertIndexIsValid(pos);
        return DateData.fromEpochDay(this.getInt(pos));
    }

    @Override
    public TimeData getTime(int pos) {
        this.assertIndexIsValid(pos);
        return TimeData.fromMillisOfDay(this.getInt(pos));
    }

    @Override
    public boolean anyNull() {
        if ((this.segments[0].getLong(0) & FIRST_BYTE_ZERO) != 0L) {
            return true;
        }
        for (int i = 8; i < this.nullBitsSizeInBytes; i += 8) {
            if (this.segments[0].getLong(i) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean anyNull(int[] fields) {
        for (int field : fields) {
            if (!this.isNullAt(field)) continue;
            return true;
        }
        return false;
    }

    public BinaryRecordData copy() {
        return this.copy(new BinaryRecordData(this.arity));
    }

    public BinaryRecordData copy(BinaryRecordData reuse) {
        return this.copyInternal(reuse);
    }

    private BinaryRecordData copyInternal(BinaryRecordData reuse) {
        byte[] bytes = BinarySegmentUtils.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        reuse.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, this.sizeInBytes);
        return reuse;
    }

    public void clear() {
        this.segments = null;
        this.offset = 0;
        this.sizeInBytes = 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryRecordData)) {
            return false;
        }
        BinarySection that = (BinarySection)o;
        return this.sizeInBytes == that.sizeInBytes && BinarySegmentUtils.equals(this.segments, this.offset, that.segments, that.offset, this.sizeInBytes);
    }

    @Override
    public int hashCode() {
        return BinarySegmentUtils.hashByWords(this.segments, this.offset, this.sizeInBytes);
    }

    public void setTotalSize(int sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }
}

