/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.config;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.connectors.base.config.SourceConfig;
import org.apache.flink.cdc.connectors.base.options.SourceOptions;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.base.utils.EnvironmentUtils;
import org.apache.flink.cdc.connectors.mongodb.source.config.MongoDBSourceConfig;
import org.apache.flink.cdc.connectors.mongodb.source.config.MongoDBSourceOptions;
import org.apache.flink.util.Preconditions;

@Internal
public class MongoDBSourceConfigFactory
implements SourceConfig.Factory<MongoDBSourceConfig> {
    private static final long serialVersionUID = 1L;
    private String scheme = (String)MongoDBSourceOptions.SCHEME.defaultValue();
    private String hosts;
    private String username;
    private String password;
    private List<String> databaseList;
    private List<String> collectionList;
    private String connectionOptions;
    private Integer batchSize = (Integer)MongoDBSourceOptions.BATCH_SIZE.defaultValue();
    private Integer pollAwaitTimeMillis = (Integer)MongoDBSourceOptions.POLL_AWAIT_TIME_MILLIS.defaultValue();
    private Integer pollMaxBatchSize = (Integer)MongoDBSourceOptions.POLL_MAX_BATCH_SIZE.defaultValue();
    private boolean updateLookup = true;
    private StartupOptions startupOptions = StartupOptions.initial();
    private Integer heartbeatIntervalMillis = (Integer)MongoDBSourceOptions.HEARTBEAT_INTERVAL_MILLIS.defaultValue();
    private Integer splitMetaGroupSize = (Integer)SourceOptions.CHUNK_META_GROUP_SIZE.defaultValue();
    private Integer splitSizeMB = (Integer)MongoDBSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE_MB.defaultValue();
    private Integer samplesPerChunk = (Integer)MongoDBSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SAMPLES.defaultValue();
    private boolean closeIdleReaders = false;
    private boolean enableFullDocPrePostImage = false;
    private boolean disableCursorTimeout = true;
    protected boolean skipSnapshotBackfill = false;
    protected boolean scanNewlyAddedTableEnabled = false;
    protected boolean assignUnboundedChunkFirst = false;

    public MongoDBSourceConfigFactory scheme(String scheme) {
        Preconditions.checkArgument(("mongodb".equals(scheme) || "mongodb+srv".equals(scheme) ? 1 : 0) != 0, (Object)String.format("The scheme should either be %s or %s", "mongodb", "mongodb+srv"));
        this.scheme = scheme;
        return this;
    }

    public MongoDBSourceConfigFactory hosts(String hosts) {
        this.hosts = hosts;
        return this;
    }

    public MongoDBSourceConfigFactory connectionOptions(String connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    public MongoDBSourceConfigFactory username(String username) {
        this.username = username;
        return this;
    }

    public MongoDBSourceConfigFactory password(String password) {
        this.password = password;
        return this;
    }

    public MongoDBSourceConfigFactory databaseList(String ... databases) {
        this.databaseList = Arrays.asList(databases);
        return this;
    }

    public MongoDBSourceConfigFactory collectionList(String ... collections) {
        this.collectionList = Arrays.asList(collections);
        return this;
    }

    public MongoDBSourceConfigFactory batchSize(int batchSize) {
        Preconditions.checkArgument((batchSize >= 0 ? 1 : 0) != 0);
        this.batchSize = batchSize;
        return this;
    }

    public MongoDBSourceConfigFactory pollAwaitTimeMillis(int pollAwaitTimeMillis) {
        Preconditions.checkArgument((pollAwaitTimeMillis > 0 ? 1 : 0) != 0);
        this.pollAwaitTimeMillis = pollAwaitTimeMillis;
        return this;
    }

    public MongoDBSourceConfigFactory pollMaxBatchSize(int pollMaxBatchSize) {
        Preconditions.checkArgument((pollMaxBatchSize > 0 ? 1 : 0) != 0);
        this.pollMaxBatchSize = pollMaxBatchSize;
        return this;
    }

    public MongoDBSourceConfigFactory startupOptions(StartupOptions startupOptions) {
        Preconditions.checkNotNull((Object)startupOptions);
        switch (startupOptions.startupMode) {
            case INITIAL: 
            case SNAPSHOT: 
            case LATEST_OFFSET: 
            case TIMESTAMP: {
                this.startupOptions = startupOptions;
                return this;
            }
        }
        throw new IllegalArgumentException("Unsupported startup mode " + (Object)((Object)startupOptions.startupMode));
    }

    public MongoDBSourceConfigFactory heartbeatIntervalMillis(int heartbeatIntervalMillis) {
        Preconditions.checkArgument((heartbeatIntervalMillis >= 0 ? 1 : 0) != 0);
        this.heartbeatIntervalMillis = heartbeatIntervalMillis;
        return this;
    }

    public MongoDBSourceConfigFactory splitSizeMB(int splitSizeMB) {
        Preconditions.checkArgument((splitSizeMB > 0 ? 1 : 0) != 0);
        this.splitSizeMB = splitSizeMB;
        return this;
    }

    public MongoDBSourceConfigFactory splitMetaGroupSize(int splitMetaGroupSize) {
        this.splitMetaGroupSize = splitMetaGroupSize;
        return this;
    }

    public MongoDBSourceConfigFactory samplesPerChunk(int samplesPerChunk) {
        Preconditions.checkArgument((samplesPerChunk > 0 ? 1 : 0) != 0);
        this.samplesPerChunk = samplesPerChunk;
        return this;
    }

    public MongoDBSourceConfigFactory closeIdleReaders(boolean closeIdleReaders) {
        this.closeIdleReaders = closeIdleReaders;
        return this;
    }

    public MongoDBSourceConfigFactory scanFullChangelog(boolean enableFullDocPrePostImage) {
        this.enableFullDocPrePostImage = enableFullDocPrePostImage;
        return this;
    }

    public MongoDBSourceConfigFactory disableCursorTimeout(boolean disableCursorTimeout) {
        this.disableCursorTimeout = disableCursorTimeout;
        return this;
    }

    public MongoDBSourceConfigFactory skipSnapshotBackfill(boolean skipSnapshotBackfill) {
        this.skipSnapshotBackfill = skipSnapshotBackfill;
        return this;
    }

    public MongoDBSourceConfigFactory scanNewlyAddedTableEnabled(boolean scanNewlyAddedTableEnabled) {
        this.scanNewlyAddedTableEnabled = scanNewlyAddedTableEnabled;
        return this;
    }

    public MongoDBSourceConfigFactory assignUnboundedChunkFirst(boolean assignUnboundedChunkFirst) {
        this.assignUnboundedChunkFirst = assignUnboundedChunkFirst;
        return this;
    }

    @Override
    public MongoDBSourceConfig create(int subtaskId) {
        EnvironmentUtils.checkSupportCheckpointsAfterTasksFinished(this.closeIdleReaders);
        return new MongoDBSourceConfig(this.scheme, this.hosts, this.username, this.password, this.databaseList, this.collectionList, this.connectionOptions, this.batchSize, this.pollAwaitTimeMillis, this.pollMaxBatchSize, this.updateLookup, this.startupOptions, this.heartbeatIntervalMillis, this.splitMetaGroupSize, this.splitSizeMB, this.samplesPerChunk, this.closeIdleReaders, this.enableFullDocPrePostImage, this.disableCursorTimeout, this.skipSnapshotBackfill, this.scanNewlyAddedTableEnabled, this.assignUnboundedChunkFirst);
    }
}

