/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.data.binary;

import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.data.binary.BinaryFormat;
import org.apache.flink.cdc.common.data.binary.BinarySegmentUtils;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public class BinarySection
implements BinaryFormat {
    protected MemorySegment[] segments;
    protected int offset;
    protected int sizeInBytes;

    public BinarySection() {
    }

    public BinarySection(MemorySegment[] segments, int offset, int sizeInBytes) {
        Preconditions.checkArgument(segments != null);
        this.segments = segments;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
    }

    public final void pointTo(MemorySegment segment, int offset, int sizeInBytes) {
        this.pointTo(new MemorySegment[]{segment}, offset, sizeInBytes);
    }

    public void pointTo(MemorySegment[] segments, int offset, int sizeInBytes) {
        Preconditions.checkArgument(segments != null);
        this.segments = segments;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public MemorySegment[] getSegments() {
        return this.segments;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinarySection that = (BinarySection)o;
        return this.sizeInBytes == that.sizeInBytes && BinarySegmentUtils.equals(this.segments, this.offset, that.segments, that.offset, this.sizeInBytes);
    }

    public int hashCode() {
        return BinarySegmentUtils.hash(this.segments, this.offset, this.sizeInBytes);
    }
}

