/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.qlik.rdbms.operations;

import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.cdc.qlik.rdbms.operations.OperationHelper;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

final class Update
implements CdcOperation {
    private static final UpdateOptions UPDATE_OPTIONS = new UpdateOptions().upsert(true);

    Update() {
    }

    @Override
    public WriteModel<BsonDocument> perform(SinkDocument doc) {
        BsonDocument keyDocument = doc.getKeyDoc().orElseThrow(() -> new DataException("Error: key doc must not be missing for update operation"));
        BsonDocument valueDocument = doc.getValueDoc().orElseThrow(() -> new DataException("Error: value doc must not be missing for update operation"));
        BsonDocument filterDocument = OperationHelper.createUpdateFilterDocument(keyDocument, valueDocument);
        BsonDocument updateDocument = OperationHelper.createUpdateDocument(valueDocument);
        if (updateDocument.isEmpty()) {
            return null;
        }
        return new UpdateOneModel<BsonDocument>((Bson)filterDocument, updateDocument, UPDATE_OPTIONS);
    }
}

