/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source;

import com.mongodb.kafka.connect.source.MongoSourceConfig;
import com.mongodb.kafka.connect.util.config.ConfigSoftValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class SourceConfigSoftValidator {
    private static final Set<ConfigSoftValidator.ObsoletePropertiesSet> OBSOLETE_PROPERTIES = Collections.unmodifiableSet(Stream.of(ConfigSoftValidator.ObsoletePropertiesSet.deprecated("copy.existing", "startup.mode", String.format("'%1$s = false' / '%1$s = true' should be replaced with '%2$s = %3$s' / '%2$s = %4$s'. All `copy.existing.*` properties should be replaced with the corresponding `startup.mode.copy.existing.*` properties.", "copy.existing", "startup.mode", MongoSourceConfig.StartupConfig.StartupMode.LATEST.propertyValue(), MongoSourceConfig.StartupConfig.StartupMode.COPY_EXISTING.propertyValue())), ConfigSoftValidator.ObsoletePropertiesSet.deprecated("copy.existing.max.threads", "startup.mode.copy.existing.max.threads", null), ConfigSoftValidator.ObsoletePropertiesSet.deprecated("copy.existing.queue.size", "startup.mode.copy.existing.queue.size", null), ConfigSoftValidator.ObsoletePropertiesSet.deprecated("copy.existing.pipeline", "startup.mode.copy.existing.pipeline", null), ConfigSoftValidator.ObsoletePropertiesSet.deprecated("copy.existing.namespace.regex", "startup.mode.copy.existing.namespace.regex", null), ConfigSoftValidator.ObsoletePropertiesSet.deprecated("copy.existing.allow.disk.use", "startup.mode.copy.existing.allow.disk.use", null)).collect(Collectors.toSet()));
    private static final Set<ConfigSoftValidator.IncompatiblePropertiesPair> INCOMPATIBLE_PROPERTIES = Collections.unmodifiableSet(Stream.of(ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("startup.mode", MongoSourceConfig.STARTUP_MODE_CONFIG_DEFAULT.propertyValue(), "copy.existing", String.valueOf(false)), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("startup.mode.copy.existing.max.threads", String.valueOf(MongoSourceConfig.STARTUP_MODE_COPY_EXISTING_MAX_THREADS_DEFAULT), "copy.existing.max.threads", String.valueOf(MongoSourceConfig.COPY_EXISTING_MAX_THREADS_DEFAULT)), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("startup.mode.copy.existing.queue.size", String.valueOf(16000), "copy.existing.queue.size", String.valueOf(16000)), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("startup.mode.copy.existing.pipeline", "", "copy.existing.pipeline", ""), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("startup.mode.copy.existing.namespace.regex", "", "copy.existing.namespace.regex", ""), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("startup.mode.copy.existing.allow.disk.use", String.valueOf(true), "copy.existing.allow.disk.use", String.valueOf(true))).collect(Collectors.toSet()));

    static void logObsoleteProperties(Collection<String> propertyNames, Consumer<String> logger) {
        ConfigSoftValidator.logObsoleteProperties(OBSOLETE_PROPERTIES, propertyNames, logger);
    }

    static void logIncompatibleProperties(Map<String, String> props, Consumer<String> logger) {
        ConfigSoftValidator.logIncompatibleProperties(INCOMPATIBLE_PROPERTIES, props, logger);
    }

    private SourceConfigSoftValidator() {
    }
}

