/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.data;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.data.TimeData;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class TimeDataSerializer
extends TypeSerializerSingleton<TimeData> {
    private static final long serialVersionUID = 1L;
    public static final TimeDataSerializer INSTANCE = new TimeDataSerializer();

    private TimeDataSerializer() {
    }

    public boolean isImmutableType() {
        return true;
    }

    public TimeData createInstance() {
        return TimeData.fromNanoOfDay(0L);
    }

    public TimeData copy(TimeData from) {
        return TimeData.fromMillisOfDay(from.toMillisOfDay());
    }

    public TimeData copy(TimeData from, TimeData reuse) {
        return TimeData.fromMillisOfDay(from.toMillisOfDay());
    }

    public int getLength() {
        return 4;
    }

    public void serialize(TimeData record, DataOutputView target) throws IOException {
        target.writeInt(record.toMillisOfDay());
    }

    public TimeData deserialize(DataInputView source) throws IOException {
        return TimeData.fromMillisOfDay(source.readInt());
    }

    public TimeData deserialize(TimeData record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeInt(source.readInt());
    }

    public TypeSerializerSnapshot<TimeData> snapshotConfiguration() {
        return new TimeDataSerializerSnapshot();
    }

    public static final class TimeDataSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<TimeData> {
        public TimeDataSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

