/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.connector.policy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigValue;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.connector.policy.ConnectorClientConfigRequest;

public abstract class AbstractConnectorClientConfigOverridePolicy
implements ConnectorClientConfigOverridePolicy {
    @Override
    public void close() {
    }

    @Override
    public final List<ConfigValue> validate(ConnectorClientConfigRequest connectorClientConfigRequest) {
        Map<String, Object> inputConfig = connectorClientConfigRequest.clientProps();
        return inputConfig.entrySet().stream().map(this::configValue).collect(Collectors.toList());
    }

    protected ConfigValue configValue(Map.Entry<String, Object> configEntry) {
        ConfigValue configValue = new ConfigValue(configEntry.getKey(), configEntry.getValue(), new ArrayList<Object>(), new ArrayList<String>());
        this.validate(configValue);
        return configValue;
    }

    protected void validate(ConfigValue configValue) {
        if (!this.isAllowed(configValue)) {
            configValue.addErrorMessage("The '" + this.policyName() + "' policy does not allow '" + configValue.name() + "' to be overridden in the connector configuration.");
        }
    }

    protected abstract String policyName();

    protected abstract boolean isAllowed(ConfigValue var1);
}

