/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema.regular.event;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;

public class SchemaChangeResponse
implements CoordinationResponse {
    private static final long serialVersionUID = 1L;
    private final List<SchemaChangeEvent> appliedSchemaChangeEvents;
    private final Map<TableId, Schema> evolvedSchemas;
    private final ResponseCode responseCode;

    public static SchemaChangeResponse success(List<SchemaChangeEvent> schemaChangeEvents, Map<TableId, Schema> evolvedSchemas) {
        return new SchemaChangeResponse(ResponseCode.SUCCESS, schemaChangeEvents, evolvedSchemas);
    }

    public static SchemaChangeResponse busy() {
        return new SchemaChangeResponse(ResponseCode.BUSY);
    }

    public static SchemaChangeResponse duplicate() {
        return new SchemaChangeResponse(ResponseCode.DUPLICATE);
    }

    public static SchemaChangeResponse ignored() {
        return new SchemaChangeResponse(ResponseCode.IGNORED);
    }

    public static SchemaChangeResponse waitingForFlush() {
        return new SchemaChangeResponse(ResponseCode.WAITING_FOR_FLUSH);
    }

    private SchemaChangeResponse(ResponseCode responseCode) {
        this(responseCode, Collections.emptyList(), Collections.emptyMap());
    }

    private SchemaChangeResponse(ResponseCode responseCode, List<SchemaChangeEvent> appliedSchemaChangeEvents, Map<TableId, Schema> evolvedSchemas) {
        this.responseCode = responseCode;
        this.appliedSchemaChangeEvents = appliedSchemaChangeEvents;
        this.evolvedSchemas = evolvedSchemas;
    }

    public boolean isSuccess() {
        return ResponseCode.SUCCESS.equals((Object)this.responseCode);
    }

    public boolean isRegistryBusy() {
        return ResponseCode.BUSY.equals((Object)this.responseCode);
    }

    public boolean isDuplicate() {
        return ResponseCode.DUPLICATE.equals((Object)this.responseCode);
    }

    public boolean isIgnored() {
        return ResponseCode.IGNORED.equals((Object)this.responseCode);
    }

    public boolean isWaitingForFlush() {
        return ResponseCode.WAITING_FOR_FLUSH.equals((Object)this.responseCode);
    }

    public List<SchemaChangeEvent> getAppliedSchemaChangeEvents() {
        return this.appliedSchemaChangeEvents;
    }

    public Map<TableId, Schema> getEvolvedSchemas() {
        return this.evolvedSchemas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaChangeResponse)) {
            return false;
        }
        SchemaChangeResponse response = (SchemaChangeResponse)o;
        return Objects.equals(this.appliedSchemaChangeEvents, response.appliedSchemaChangeEvents) && this.responseCode == response.responseCode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appliedSchemaChangeEvents, this.responseCode});
    }

    public String toString() {
        return "SchemaChangeResponse{schemaChangeEvents=" + this.appliedSchemaChangeEvents + ", responseCode=" + (Object)((Object)this.responseCode) + '}';
    }

    public static enum ResponseCode {
        SUCCESS,
        BUSY,
        DUPLICATE,
        IGNORED,
        WAITING_FOR_FLUSH;

    }
}

