/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.event.AddColumnEvent;
import org.apache.flink.cdc.common.event.AlterColumnTypeEvent;
import org.apache.flink.cdc.common.event.DropColumnEvent;
import org.apache.flink.cdc.common.event.RenameColumnEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.visitor.SchemaChangeEventVisitor;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeFamily;
import org.apache.flink.cdc.common.types.DataTypeRoot;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.types.DecimalType;
import org.apache.flink.cdc.common.types.LocalZonedTimestampType;
import org.apache.flink.cdc.common.types.TimestampType;
import org.apache.flink.cdc.common.types.ZonedTimestampType;
import org.apache.flink.cdc.common.utils.Preconditions;

@PublicEvolving
public class SchemaUtils {
    @CheckReturnValue
    public static List<RecordData.FieldGetter> createFieldGetters(Schema schema) {
        return SchemaUtils.createFieldGetters(schema.getColumns());
    }

    @CheckReturnValue
    public static List<RecordData.FieldGetter> createFieldGetters(List<Column> columns) {
        ArrayList<RecordData.FieldGetter> fieldGetters = new ArrayList<RecordData.FieldGetter>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            fieldGetters.add(RecordData.createFieldGetter(columns.get(i).getType(), i));
        }
        return fieldGetters;
    }

    @CheckReturnValue
    public static List<Object> restoreOriginalData(@Nullable RecordData recordData, List<RecordData.FieldGetter> fieldGetters) {
        if (recordData == null) {
            return null;
        }
        ArrayList<Object> actualFields = new ArrayList<Object>();
        for (RecordData.FieldGetter fieldGetter : fieldGetters) {
            actualFields.add(fieldGetter.getFieldOrNull(recordData));
        }
        return actualFields;
    }

    @CheckReturnValue
    public static Schema applySchemaChangeEvent(Schema schema, SchemaChangeEvent event) {
        return SchemaChangeEventVisitor.visit(event, addColumnEvent -> SchemaUtils.applyAddColumnEvent(addColumnEvent, schema), alterColumnTypeEvent -> SchemaUtils.applyAlterColumnTypeEvent(alterColumnTypeEvent, schema), createTableEvent -> createTableEvent.getSchema(), dropColumnEvent -> SchemaUtils.applyDropColumnEvent(dropColumnEvent, schema), dropTableEvent -> schema, renameColumnEvent -> SchemaUtils.applyRenameColumnEvent(renameColumnEvent, schema), truncateTableEvent -> schema);
    }

    private static Schema applyAddColumnEvent(AddColumnEvent event, Schema oldSchema) {
        LinkedList<Column> columns = new LinkedList<Column>(oldSchema.getColumns());
        for (AddColumnEvent.ColumnWithPosition columnWithPosition : event.getAddedColumns()) {
            switch (columnWithPosition.getPosition()) {
                case FIRST: {
                    columns.addFirst(columnWithPosition.getAddColumn());
                    break;
                }
                case LAST: {
                    columns.addLast(columnWithPosition.getAddColumn());
                    break;
                }
                case BEFORE: {
                    Preconditions.checkNotNull(columnWithPosition.getExistedColumnName(), "existedColumnName could not be null in BEFORE type AddColumnEvent");
                    List columnNames = columns.stream().map(Column::getName).collect(Collectors.toList());
                    int index = columnNames.indexOf(columnWithPosition.getExistedColumnName());
                    if (index < 0) {
                        throw new IllegalArgumentException(columnWithPosition.getExistedColumnName() + " of AddColumnEvent is not existed");
                    }
                    columns.add(index, columnWithPosition.getAddColumn());
                    break;
                }
                case AFTER: {
                    Preconditions.checkNotNull(columnWithPosition.getExistedColumnName(), "existedColumnName could not be null in AFTER type AddColumnEvent");
                    List columnNames = columns.stream().map(Column::getName).collect(Collectors.toList());
                    int index = columnNames.indexOf(columnWithPosition.getExistedColumnName());
                    if (index < 0) {
                        throw new IllegalArgumentException(columnWithPosition.getExistedColumnName() + " of AddColumnEvent is not existed");
                    }
                    columns.add(index + 1, columnWithPosition.getAddColumn());
                    break;
                }
            }
        }
        return oldSchema.copy(columns);
    }

    private static Schema applyDropColumnEvent(DropColumnEvent event, Schema oldSchema) {
        List<Column> columns = oldSchema.getColumns().stream().filter(column -> !event.getDroppedColumnNames().contains(column.getName())).collect(Collectors.toList());
        return oldSchema.copy(columns);
    }

    private static Schema applyRenameColumnEvent(RenameColumnEvent event, Schema oldSchema) {
        ArrayList<Column> columns = new ArrayList<Column>();
        oldSchema.getColumns().forEach(column -> {
            if (event.getNameMapping().containsKey(column.getName())) {
                columns.add(column.copy(event.getNameMapping().get(column.getName())));
            } else {
                columns.add((Column)column);
            }
        });
        return oldSchema.copy(columns);
    }

    private static Schema applyAlterColumnTypeEvent(AlterColumnTypeEvent event, Schema oldSchema) {
        ArrayList<Column> columns = new ArrayList<Column>();
        oldSchema.getColumns().forEach(column -> {
            if (event.getTypeMapping().containsKey(column.getName())) {
                columns.add(column.copy(event.getTypeMapping().get(column.getName())));
            } else {
                columns.add((Column)column);
            }
        });
        return oldSchema.copy(columns);
    }

    @CheckReturnValue
    public static Optional<SchemaChangeEvent> transformSchemaChangeEvent(boolean hasAsterisk, List<String> referencedColumns, SchemaChangeEvent event) {
        Optional<SchemaChangeEvent> evolvedSchemaChangeEvent = Optional.empty();
        if (event instanceof AddColumnEvent) {
            if (hasAsterisk) {
                List<AddColumnEvent.ColumnWithPosition> addedColumns = ((AddColumnEvent)event).getAddedColumns().stream().map(e -> {
                    if (AddColumnEvent.ColumnPosition.LAST.equals(e.getPosition())) {
                        return new AddColumnEvent.ColumnWithPosition(e.getAddColumn(), AddColumnEvent.ColumnPosition.AFTER, (String)referencedColumns.get(referencedColumns.size() - 1));
                    }
                    if (AddColumnEvent.ColumnPosition.FIRST.equals(e.getPosition())) {
                        return new AddColumnEvent.ColumnWithPosition(e.getAddColumn(), AddColumnEvent.ColumnPosition.BEFORE, (String)referencedColumns.get(0));
                    }
                    return e;
                }).collect(Collectors.toList());
                evolvedSchemaChangeEvent = Optional.of(new AddColumnEvent(event.tableId(), addedColumns));
            }
        } else if (event instanceof AlterColumnTypeEvent) {
            AlterColumnTypeEvent alterColumnTypeEvent = (AlterColumnTypeEvent)event;
            if (hasAsterisk) {
                evolvedSchemaChangeEvent = Optional.of(event);
            } else {
                Map<String, DataType> newDataTypeMap = alterColumnTypeEvent.getTypeMapping().entrySet().stream().filter(e -> referencedColumns.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (!newDataTypeMap.isEmpty()) {
                    evolvedSchemaChangeEvent = Optional.of(new AlterColumnTypeEvent(alterColumnTypeEvent.tableId(), newDataTypeMap));
                }
            }
        } else if (event instanceof RenameColumnEvent) {
            if (hasAsterisk) {
                evolvedSchemaChangeEvent = Optional.of(event);
            }
        } else if (event instanceof DropColumnEvent) {
            if (hasAsterisk) {
                evolvedSchemaChangeEvent = Optional.of(event);
            }
        } else {
            evolvedSchemaChangeEvent = Optional.of(event);
        }
        return evolvedSchemaChangeEvent;
    }

    public static boolean isSchemaChangeEventRedundant(@Nullable Schema currentSchema, SchemaChangeEvent event) {
        Optional<Schema> latestSchema = Optional.ofNullable(currentSchema);
        return Boolean.TRUE.equals(SchemaChangeEventVisitor.visit(event, addColumnEvent -> {
            if (!latestSchema.isPresent()) {
                return false;
            }
            List<Column> existedColumns = ((Schema)latestSchema.get()).getColumns();
            for (AddColumnEvent.ColumnWithPosition column : addColumnEvent.getAddedColumns()) {
                if (existedColumns.contains(column.getAddColumn())) continue;
                return false;
            }
            return true;
        }, alterColumnTypeEvent -> {
            if (!latestSchema.isPresent()) {
                return false;
            }
            Schema schema = (Schema)latestSchema.get();
            for (Map.Entry<String, DataType> entry : alterColumnTypeEvent.getTypeMapping().entrySet()) {
                if (schema.getColumn(entry.getKey()).isPresent() && schema.getColumn(entry.getKey()).get().getType().equals(entry.getValue())) continue;
                return false;
            }
            return true;
        }, createTableEvent -> latestSchema.isPresent(), dropColumnEvent -> {
            if (!latestSchema.isPresent()) {
                return false;
            }
            List<String> existedColumnNames = ((Schema)latestSchema.get()).getColumnNames();
            return dropColumnEvent.getDroppedColumnNames().stream().noneMatch(existedColumnNames::contains);
        }, dropTableEvent -> !latestSchema.isPresent(), renameColumnEvent -> {
            if (!latestSchema.isPresent()) {
                return false;
            }
            List<String> existedColumnNames = ((Schema)latestSchema.get()).getColumnNames();
            for (Map.Entry<String, String> entry : renameColumnEvent.getNameMapping().entrySet()) {
                if (!existedColumnNames.contains(entry.getKey()) && existedColumnNames.contains(entry.getValue())) continue;
                return false;
            }
            return true;
        }, truncateTableEvent -> false));
    }

    @Deprecated
    public static Schema inferWiderSchema(List<Schema> schemas) {
        if (schemas.isEmpty()) {
            return null;
        }
        if (schemas.size() == 1) {
            return schemas.get(0);
        }
        Schema outputSchema = null;
        for (Schema schema : schemas) {
            outputSchema = SchemaUtils.inferWiderSchema(outputSchema, schema);
        }
        return outputSchema;
    }

    @Deprecated
    @VisibleForTesting
    public static Schema inferWiderSchema(@Nullable Schema lSchema, Schema rSchema) {
        if (lSchema == null) {
            return rSchema;
        }
        if (lSchema.getColumnCount() != rSchema.getColumnCount()) {
            throw new IllegalStateException(String.format("Unable to merge schema %s and %s with different column counts.", lSchema, rSchema));
        }
        if (!lSchema.primaryKeys().equals(rSchema.primaryKeys())) {
            throw new IllegalStateException(String.format("Unable to merge schema %s and %s with different primary keys.", lSchema, rSchema));
        }
        if (!lSchema.partitionKeys().equals(rSchema.partitionKeys())) {
            throw new IllegalStateException(String.format("Unable to merge schema %s and %s with different partition keys.", lSchema, rSchema));
        }
        if (!lSchema.options().equals(rSchema.options())) {
            throw new IllegalStateException(String.format("Unable to merge schema %s and %s with different options.", lSchema, rSchema));
        }
        if (!Objects.equals(lSchema.comment(), rSchema.comment())) {
            throw new IllegalStateException(String.format("Unable to merge schema %s and %s with different comments.", lSchema, rSchema));
        }
        List<Column> leftColumns = lSchema.getColumns();
        List<Column> rightColumns = rSchema.getColumns();
        List<Column> mergedColumns = IntStream.range(0, lSchema.getColumnCount()).mapToObj(i -> SchemaUtils.inferWiderColumn((Column)leftColumns.get(i), (Column)rightColumns.get(i))).collect(Collectors.toList());
        return lSchema.copy(mergedColumns);
    }

    @Deprecated
    @VisibleForTesting
    public static Column inferWiderColumn(Column lColumn, Column rColumn) {
        if (!Objects.equals(lColumn.getName(), rColumn.getName())) {
            throw new IllegalStateException(String.format("Unable to merge column %s and %s with different name.", lColumn, rColumn));
        }
        if (!Objects.equals(lColumn.getComment(), rColumn.getComment())) {
            throw new IllegalStateException(String.format("Unable to merge column %s and %s with different comments.", lColumn, rColumn));
        }
        return lColumn.copy(SchemaUtils.inferWiderType(lColumn.getType(), rColumn.getType()));
    }

    @Deprecated
    @VisibleForTesting
    public static DataType inferWiderType(DataType lType, DataType rType) {
        DataType mergedType;
        boolean nullable = lType.isNullable() || rType.isNullable();
        if ((lType = lType.notNull()).equals(rType = rType.notNull())) {
            mergedType = rType;
        } else {
            if (lType instanceof TimestampType && rType instanceof TimestampType) {
                return DataTypes.TIMESTAMP(Math.max(((TimestampType)lType).getPrecision(), ((TimestampType)rType).getPrecision()));
            }
            if (lType instanceof ZonedTimestampType && rType instanceof ZonedTimestampType) {
                return DataTypes.TIMESTAMP_TZ(Math.max(((ZonedTimestampType)lType).getPrecision(), ((ZonedTimestampType)rType).getPrecision()));
            }
            if (lType instanceof LocalZonedTimestampType && rType instanceof LocalZonedTimestampType) {
                return DataTypes.TIMESTAMP_LTZ(Math.max(((LocalZonedTimestampType)lType).getPrecision(), ((LocalZonedTimestampType)rType).getPrecision()));
            }
            if (lType.is(DataTypeFamily.TIMESTAMP) && rType.is(DataTypeFamily.TIMESTAMP)) {
                return DataTypes.TIMESTAMP(9);
            }
            if (lType.is(DataTypeFamily.INTEGER_NUMERIC) && rType.is(DataTypeFamily.INTEGER_NUMERIC)) {
                mergedType = DataTypes.BIGINT();
            } else if (lType.is(DataTypeFamily.CHARACTER_STRING) && rType.is(DataTypeFamily.CHARACTER_STRING)) {
                mergedType = DataTypes.STRING();
            } else if (lType.is(DataTypeFamily.APPROXIMATE_NUMERIC) && rType.is(DataTypeFamily.APPROXIMATE_NUMERIC)) {
                mergedType = DataTypes.DOUBLE();
            } else if (lType instanceof DecimalType && rType instanceof DecimalType) {
                int resultScale;
                DecimalType lhsDecimal = (DecimalType)lType;
                DecimalType rhsDecimal = (DecimalType)rType;
                int resultIntDigits = Math.max(lhsDecimal.getPrecision() - lhsDecimal.getScale(), rhsDecimal.getPrecision() - rhsDecimal.getScale());
                Preconditions.checkArgument(resultIntDigits + (resultScale = Math.max(lhsDecimal.getScale(), rhsDecimal.getScale())) <= 38, String.format("Failed to merge %s and %s type into DECIMAL. %d precision digits required, %d available", lType, rType, resultIntDigits + resultScale, 38), new Object[0]);
                mergedType = DataTypes.DECIMAL(resultIntDigits + resultScale, resultScale);
            } else if (lType instanceof DecimalType && rType.is(DataTypeFamily.EXACT_NUMERIC)) {
                mergedType = SchemaUtils.mergeExactNumericsIntoDecimal((DecimalType)lType, rType);
            } else if (rType instanceof DecimalType && lType.is(DataTypeFamily.EXACT_NUMERIC)) {
                mergedType = SchemaUtils.mergeExactNumericsIntoDecimal((DecimalType)rType, lType);
            } else {
                throw new IllegalStateException(String.format("Incompatible types: \"%s\" and \"%s\"", lType, rType));
            }
        }
        if (nullable) {
            return mergedType.nullable();
        }
        return mergedType.notNull();
    }

    private static DataType mergeExactNumericsIntoDecimal(DecimalType decimalType, DataType otherType) {
        int resultPrecision = Math.max(decimalType.getPrecision(), decimalType.getScale() + SchemaUtils.getNumericPrecision(otherType));
        Preconditions.checkArgument(resultPrecision <= 38, String.format("Failed to merge %s and %s type into DECIMAL. %d precision digits required, %d available", decimalType, otherType, resultPrecision, 38), new Object[0]);
        return DataTypes.DECIMAL(resultPrecision, decimalType.getScale());
    }

    @Deprecated
    @VisibleForTesting
    public static int getNumericPrecision(DataType dataType) {
        if (dataType.is(DataTypeFamily.EXACT_NUMERIC)) {
            if (dataType.is(DataTypeRoot.TINYINT)) {
                return 3;
            }
            if (dataType.is(DataTypeRoot.SMALLINT)) {
                return 5;
            }
            if (dataType.is(DataTypeRoot.INTEGER)) {
                return 10;
            }
            if (dataType.is(DataTypeRoot.BIGINT)) {
                return 19;
            }
            if (dataType.is(DataTypeRoot.DECIMAL)) {
                return ((DecimalType)dataType).getPrecision();
            }
        }
        throw new IllegalArgumentException("Failed to get precision of non-exact decimal type " + dataType);
    }
}

