/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Lsn;
import io.debezium.connector.db2.SourceInfo;
import io.debezium.connector.db2.TxLogPosition;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;

public class Db2OffsetContext
implements OffsetContext {
    private static final String SERVER_PARTITION_KEY = "server";
    private static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    private static final String EVENT_SERIAL_NO_KEY = "event_serial_no";
    private final Schema sourceInfoSchema;
    private final SourceInfo sourceInfo;
    private boolean snapshotCompleted;
    private final TransactionContext transactionContext;
    private final IncrementalSnapshotContext<TableId> incrementalSnapshotContext;
    private long eventSerialNo;

    public Db2OffsetContext(Db2ConnectorConfig connectorConfig, TxLogPosition position, boolean snapshot, boolean snapshotCompleted, long eventSerialNo, TransactionContext transactionContext, IncrementalSnapshotContext<TableId> incrementalSnapshotContext) {
        this.sourceInfo = new SourceInfo(connectorConfig);
        this.sourceInfo.setCommitLsn(position.getCommitLsn());
        this.sourceInfo.setChangeLsn(position.getInTxLsn());
        this.sourceInfoSchema = this.sourceInfo.schema();
        this.snapshotCompleted = snapshotCompleted;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            this.sourceInfo.setSnapshot(snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
        this.eventSerialNo = eventSerialNo;
        this.transactionContext = transactionContext;
        this.incrementalSnapshotContext = incrementalSnapshotContext;
    }

    public Db2OffsetContext(Db2ConnectorConfig connectorConfig, TxLogPosition position, boolean snapshot, boolean snapshotCompleted) {
        this(connectorConfig, position, snapshot, snapshotCompleted, 1L, new TransactionContext(), new SignalBasedIncrementalSnapshotContext<TableId>(false));
    }

    @Override
    public Map<String, ?> getOffset() {
        if (this.sourceInfo.isSnapshot()) {
            return Collect.hashMapOf("snapshot", true, SNAPSHOT_COMPLETED_KEY, this.snapshotCompleted, "commit_lsn", this.sourceInfo.getCommitLsn().toString());
        }
        return this.incrementalSnapshotContext.store(this.transactionContext.store(Collect.hashMapOf("commit_lsn", this.sourceInfo.getCommitLsn().toString(), "change_lsn", this.sourceInfo.getChangeLsn() == null ? null : this.sourceInfo.getChangeLsn().toString(), EVENT_SERIAL_NO_KEY, this.eventSerialNo)));
    }

    @Override
    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    @Override
    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    public TxLogPosition getChangePosition() {
        return TxLogPosition.valueOf(this.sourceInfo.getCommitLsn(), this.sourceInfo.getChangeLsn());
    }

    public long getEventSerialNo() {
        return this.eventSerialNo;
    }

    public void setChangePosition(TxLogPosition position, int eventCount) {
        this.eventSerialNo = this.getChangePosition().equals(position) ? (this.eventSerialNo += (long)eventCount) : (long)eventCount;
        this.sourceInfo.setCommitLsn(position.getCommitLsn());
        this.sourceInfo.setChangeLsn(position.getInTxLsn());
    }

    @Override
    public boolean isSnapshotRunning() {
        return this.sourceInfo.isSnapshot() && !this.snapshotCompleted;
    }

    public boolean isSnapshotCompleted() {
        return this.snapshotCompleted;
    }

    @Override
    public void preSnapshotStart() {
        this.sourceInfo.setSnapshot(SnapshotRecord.TRUE);
        this.snapshotCompleted = false;
    }

    @Override
    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    @Override
    public void postSnapshotCompletion() {
        this.sourceInfo.setSnapshot(SnapshotRecord.FALSE);
    }

    public String toString() {
        return "Db2OffsetContext [sourceInfoSchema=" + this.sourceInfoSchema + ", sourceInfo=" + this.sourceInfo + ", snapshotCompleted=" + this.snapshotCompleted + ", eventSerialNo=" + this.eventSerialNo + "]";
    }

    @Override
    public void markLastSnapshotRecord() {
        this.sourceInfo.setSnapshot(SnapshotRecord.LAST);
    }

    @Override
    public void event(DataCollectionId tableId, Instant timestamp) {
        this.sourceInfo.setSourceTime(timestamp);
        this.sourceInfo.setTableId((TableId)tableId);
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public void incrementalSnapshotEvents() {
        this.sourceInfo.setSnapshot(SnapshotRecord.INCREMENTAL);
    }

    @Override
    public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return this.incrementalSnapshotContext;
    }

    public static class Loader
    implements OffsetContext.Loader<Db2OffsetContext> {
        private final Db2ConnectorConfig connectorConfig;

        public Loader(Db2ConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        @Override
        public Db2OffsetContext load(Map<String, ?> offset) {
            Lsn changeLsn = Lsn.valueOf((String)offset.get("change_lsn"));
            Lsn commitLsn = Lsn.valueOf((String)offset.get("commit_lsn"));
            boolean snapshot = Boolean.TRUE.equals(offset.get("snapshot"));
            boolean snapshotCompleted = Boolean.TRUE.equals(offset.get(Db2OffsetContext.SNAPSHOT_COMPLETED_KEY));
            Long eventSerialNo = (Long)offset.get(Db2OffsetContext.EVENT_SERIAL_NO_KEY);
            if (eventSerialNo == null) {
                eventSerialNo = 0L;
            }
            return new Db2OffsetContext(this.connectorConfig, TxLogPosition.valueOf(commitLsn, changeLsn), snapshot, snapshotCompleted, eventSerialNo, TransactionContext.load(offset), SignalBasedIncrementalSnapshotContext.load(offset, false));
        }
    }
}

