/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.schema;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.runtime.serializer.ListSerializer;
import org.apache.flink.cdc.runtime.serializer.MapSerializer;
import org.apache.flink.cdc.runtime.serializer.StringSerializer;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.cdc.runtime.serializer.schema.ColumnSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class SchemaSerializer
extends TypeSerializerSingleton<Schema> {
    private static final long serialVersionUID = 1L;
    public static final SchemaSerializer INSTANCE = new SchemaSerializer();
    private final ListSerializer<Column> columnsSerializer = new ListSerializer<Column>(ColumnSerializer.INSTANCE);
    private final ListSerializer<String> primaryKeysSerializer = new ListSerializer<String>(StringSerializer.INSTANCE);
    private final ListSerializer<String> partitionKeysSerializer = new ListSerializer<String>(StringSerializer.INSTANCE);
    private final MapSerializer<String, String> optionsSerializer = new MapSerializer<String, String>(StringSerializer.INSTANCE, StringSerializer.INSTANCE);
    private final StringSerializer stringSerializer = StringSerializer.INSTANCE;
    private static final int CURRENT_VERSION = 2;

    public boolean isImmutableType() {
        return false;
    }

    public Schema createInstance() {
        return Schema.newBuilder().build();
    }

    public Schema copy(Schema from) {
        return Schema.newBuilder().setColumns(this.columnsSerializer.copy(from.getColumns())).primaryKey(this.primaryKeysSerializer.copy(from.primaryKeys())).partitionKey(this.partitionKeysSerializer.copy(from.partitionKeys())).options(this.optionsSerializer.copy(from.options())).comment(this.stringSerializer.copy(from.comment())).build();
    }

    public Schema copy(Schema from, Schema reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(Schema record, DataOutputView target) throws IOException {
        this.columnsSerializer.serialize(record.getColumns(), target);
        this.primaryKeysSerializer.serialize(record.primaryKeys(), target);
        this.partitionKeysSerializer.serialize(record.partitionKeys(), target);
        this.optionsSerializer.serialize(record.options(), target);
        this.stringSerializer.serialize(record.comment(), target);
    }

    public Schema deserialize(DataInputView source) throws IOException {
        return this.deserialize(2, source);
    }

    public Schema deserialize(int version, DataInputView source) throws IOException {
        ColumnSerializer.updateVersion(version);
        switch (version) {
            case 0: {
                return Schema.newBuilder().setColumns((List<Column>)this.columnsSerializer.deserialize(source)).primaryKey((List<String>)this.primaryKeysSerializer.deserialize(source)).options((Map<String, String>)this.optionsSerializer.deserialize(source)).comment(this.stringSerializer.deserialize(source)).build();
            }
            case 1: 
            case 2: {
                return Schema.newBuilder().setColumns((List<Column>)this.columnsSerializer.deserialize(source)).primaryKey((List<String>)this.primaryKeysSerializer.deserialize(source)).partitionKey((List<String>)this.partitionKeysSerializer.deserialize(source)).options((Map<String, String>)this.optionsSerializer.deserialize(source)).comment(this.stringSerializer.deserialize(source)).build();
            }
        }
        throw new IOException("Unrecognized serialization version " + version);
    }

    public Schema deserialize(Schema reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<Schema> snapshotConfiguration() {
        return new SchemaSerializerSnapshot();
    }

    public static final class SchemaSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Schema> {
        public SchemaSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

