/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeRoot;
import org.apache.flink.cdc.common.types.DataTypeVisitor;
import org.apache.flink.cdc.common.utils.Preconditions;

@PublicEvolving
public final class MapType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT = "MAP<%s, %s>";
    private final DataType keyType;
    private final DataType valueType;

    public MapType(boolean isNullable, DataType keyType, DataType valueType) {
        super(isNullable, DataTypeRoot.MAP);
        this.keyType = Preconditions.checkNotNull(keyType, "Key type must not be null.");
        this.valueType = Preconditions.checkNotNull(valueType, "Value type must not be null.");
    }

    public MapType(DataType keyType, DataType valueType) {
        this(true, keyType, valueType);
    }

    public DataType getKeyType() {
        return this.keyType;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new MapType(isNullable, this.keyType.copy(), this.valueType.copy());
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, this.keyType.asSummaryString(), this.valueType.asSummaryString());
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, this.keyType.asSerializableString(), this.valueType.asSerializableString());
    }

    @Override
    public List<DataType> getChildren() {
        return Collections.unmodifiableList(Arrays.asList(this.keyType, this.valueType));
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MapType mapType = (MapType)o;
        return this.keyType.equals(mapType.keyType) && this.valueType.equals(mapType.valueType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keyType, this.valueType);
    }
}

