/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.connector.db2.Db2ObjectNameQuoter;
import io.debezium.connector.db2.Lsn;
import io.debezium.relational.ChangeTable;
import io.debezium.relational.TableId;

public class Db2ChangeTable
extends ChangeTable {
    private static final String CDC_SCHEMA = "ASNCDC";
    private final Lsn startLsn;
    private Lsn stopLsn;
    private final String db2CaptureInstance;

    public Db2ChangeTable(TableId sourceTableId, String captureInstance, int changeTableObjectId, Lsn startLsn, Lsn stopLsn) {
        super(captureInstance, sourceTableId, Db2ChangeTable.resolveChangeTableId(sourceTableId, captureInstance), changeTableObjectId);
        this.startLsn = startLsn;
        this.stopLsn = stopLsn;
        this.db2CaptureInstance = Db2ObjectNameQuoter.quoteNameIfNecessary(captureInstance);
    }

    public Db2ChangeTable(String captureInstance, int changeTableObjectId, Lsn startLsn, Lsn stopLsn) {
        this(null, captureInstance, changeTableObjectId, startLsn, stopLsn);
    }

    @Override
    public String getCaptureInstance() {
        return this.db2CaptureInstance;
    }

    public Lsn getStartLsn() {
        return this.startLsn;
    }

    public Lsn getStopLsn() {
        return this.stopLsn;
    }

    public void setStopLsn(Lsn stopLsn) {
        this.stopLsn = stopLsn;
    }

    @Override
    public String toString() {
        return "Capture instance \"" + this.getCaptureInstance() + "\" [sourceTableId=" + this.getSourceTableId() + ", changeTableId=" + this.getChangeTableId() + ", startLsn=" + this.startLsn + ", changeTableObjectId=" + this.getChangeTableObjectId() + ", stopLsn=" + this.stopLsn + "]";
    }

    private static TableId resolveChangeTableId(TableId sourceTableId, String captureInstance) {
        return sourceTableId != null ? new TableId(sourceTableId.catalog(), CDC_SCHEMA, Db2ObjectNameQuoter.quoteNameIfNecessary(captureInstance)) : null;
    }
}

