/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway;

import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.internal.StaticResultProvider;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.util.CloseableIterator;

public class StatementResult
implements CloseableIterator<RowData> {
    private final ResolvedSchema resultSchema;
    private final CloseableIterator<RowData> resultProvider;
    private final boolean isQueryResult;
    private final ResultKind resultKind;
    @Nullable
    private final JobID jobID;
    private final RowDataToStringConverter toStringConverter;

    public StatementResult(ResolvedSchema resultSchema, CloseableIterator<RowData> resultProvider, boolean isQueryResult, ResultKind resultKind, @Nullable JobID jobID) {
        this(resultSchema, resultProvider, isQueryResult, resultKind, jobID, StaticResultProvider.SIMPLE_ROW_DATA_TO_STRING_CONVERTER);
    }

    @VisibleForTesting
    public StatementResult(ResolvedSchema resultSchema, CloseableIterator<RowData> resultProvider, boolean isQueryResult, ResultKind resultKind, @Nullable JobID jobID, RowDataToStringConverter toStringConverter) {
        this.resultSchema = resultSchema;
        this.resultProvider = resultProvider;
        this.isQueryResult = isQueryResult;
        this.resultKind = resultKind;
        this.jobID = jobID;
        this.toStringConverter = toStringConverter;
    }

    public ResolvedSchema getResultSchema() {
        return this.resultSchema;
    }

    public boolean isQueryResult() {
        return this.isQueryResult;
    }

    @Nullable
    public JobID getJobId() {
        return this.jobID;
    }

    public ResultKind getResultKind() {
        return this.resultKind;
    }

    public RowDataToStringConverter getRowDataToStringConverter() {
        return this.toStringConverter;
    }

    public void close() {
        try {
            this.resultProvider.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasNext() {
        return this.resultProvider.hasNext();
    }

    public RowData next() {
        return (RowData)this.resultProvider.next();
    }
}

