/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.avro.shaded.org.apache.avro.file.CodecFactory;
import org.apache.flink.avro.shaded.org.apache.avro.file.DataFileWriter;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericData;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericDatumWriter;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericRecord;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.table.factories.BulkReaderFormatFactory;
import org.apache.flink.connector.file.table.factories.BulkWriterFormatFactory;
import org.apache.flink.connector.file.table.format.BulkDecodingFormat;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.formats.avro.AbstractAvroBulkFormat;
import org.apache.flink.formats.avro.AvroBuilder;
import org.apache.flink.formats.avro.AvroFormatOptions;
import org.apache.flink.formats.avro.AvroToRowDataConverters;
import org.apache.flink.formats.avro.AvroWriterFactory;
import org.apache.flink.formats.avro.RowDataToAvroConverters;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.ProjectableDecodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class AvroFileFormatFactory
implements BulkReaderFormatFactory,
BulkWriterFormatFactory {
    public static final String IDENTIFIER = "avro";

    public BulkDecodingFormat<RowData> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        return new AvroBulkDecodingFormat();
    }

    public EncodingFormat<BulkWriter.Factory<RowData>> createEncodingFormat(DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        return new EncodingFormat<BulkWriter.Factory<RowData>>(){

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }

            public BulkWriter.Factory<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                return new RowDataAvroWriterFactory((RowType)consumedDataType.getLogicalType(), (String)formatOptions.get(AvroFormatOptions.AVRO_OUTPUT_CODEC), (Boolean)formatOptions.get(AvroFormatOptions.AVRO_TIMESTAMP_LEGACY_MAPPING));
            }
        };
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(AvroFormatOptions.AVRO_OUTPUT_CODEC);
        options.add(AvroFormatOptions.AVRO_TIMESTAMP_LEGACY_MAPPING);
        return options;
    }

    public Set<ConfigOption<?>> forwardOptions() {
        return this.optionalOptions();
    }

    private static class RowDataAvroWriterFactory
    implements BulkWriter.Factory<RowData> {
        private static final long serialVersionUID = 1L;
        private final AvroWriterFactory<GenericRecord> factory;
        private final RowType rowType;

        private RowDataAvroWriterFactory(final RowType rowType, final String codec, final boolean legacyTimestampMapping) {
            this.rowType = rowType;
            this.factory = new AvroWriterFactory<GenericRecord>(new AvroBuilder<GenericRecord>(){

                @Override
                public DataFileWriter<GenericRecord> createWriter(OutputStream out) throws IOException {
                    Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)rowType, legacyTimestampMapping);
                    GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
                    DataFileWriter<GenericRecord> dataFileWriter = new DataFileWriter<GenericRecord>(datumWriter);
                    if (codec != null) {
                        dataFileWriter.setCodec(CodecFactory.fromString(codec));
                    }
                    dataFileWriter.create(schema, out);
                    return dataFileWriter;
                }
            });
        }

        public BulkWriter<RowData> create(FSDataOutputStream out) throws IOException {
            final BulkWriter<GenericRecord> writer = this.factory.create(out);
            final RowDataToAvroConverters.RowDataToAvroConverter converter = RowDataToAvroConverters.createConverter((LogicalType)this.rowType);
            final Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)this.rowType);
            return new BulkWriter<RowData>(){

                public void addElement(RowData element) throws IOException {
                    GenericRecord record = (GenericRecord)converter.convert(schema, element);
                    writer.addElement((Object)record);
                }

                public void flush() throws IOException {
                    writer.flush();
                }

                public void finish() throws IOException {
                    writer.finish();
                }
            };
        }
    }

    private static class AvroGenericRecordBulkFormat
    extends AbstractAvroBulkFormat<GenericRecord, RowData, FileSourceSplit> {
        private static final long serialVersionUID = 1L;
        private final RowType producedRowType;
        private final TypeInformation<RowData> producedTypeInfo;

        public AvroGenericRecordBulkFormat(DynamicTableSource.Context context, RowType producedRowType) {
            super(AvroSchemaConverter.convertToSchema((LogicalType)producedRowType));
            this.producedRowType = producedRowType;
            this.producedTypeInfo = context.createTypeInformation((LogicalType)producedRowType);
        }

        @Override
        protected GenericRecord createReusedAvroRecord() {
            return new GenericData.Record(this.readerSchema);
        }

        @Override
        protected Function<GenericRecord, RowData> createConverter() {
            AvroToRowDataConverters.AvroToRowDataConverter converter = AvroToRowDataConverters.createRowConverter(this.producedRowType);
            return record -> record == null ? null : (GenericRowData)converter.convert(record);
        }

        public TypeInformation<RowData> getProducedType() {
            return this.producedTypeInfo;
        }
    }

    private static class AvroBulkDecodingFormat
    implements BulkDecodingFormat<RowData>,
    ProjectableDecodingFormat<BulkFormat<RowData, FileSourceSplit>> {
        private AvroBulkDecodingFormat() {
        }

        public BulkFormat<RowData, FileSourceSplit> createRuntimeDecoder(DynamicTableSource.Context context, DataType physicalDataType, int[][] projections) {
            DataType producedDataType = Projection.of((int[][])projections).project(physicalDataType);
            return new AvroGenericRecordBulkFormat(context, (RowType)producedDataType.getLogicalType().copy(false));
        }

        public ChangelogMode getChangelogMode() {
            return ChangelogMode.insertOnly();
        }
    }
}

