/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.registry.confluent;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.formats.avro.SchemaCoder;

public class ConfluentSchemaRegistryCoder
implements SchemaCoder {
    private final SchemaRegistryClient schemaRegistryClient;
    private String subject;
    private static final int CONFLUENT_MAGIC_BYTE = 0;

    public ConfluentSchemaRegistryCoder(String subject, SchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistryClient = schemaRegistryClient;
        this.subject = subject;
    }

    public ConfluentSchemaRegistryCoder(SchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistryClient = schemaRegistryClient;
    }

    @Override
    public Schema readSchema(InputStream in) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(in);
        if (dataInputStream.readByte() != 0) {
            throw new IOException("Unknown data format. Magic number does not match");
        }
        int schemaId = dataInputStream.readInt();
        try {
            return this.schemaRegistryClient.getById(schemaId);
        }
        catch (RestClientException e) {
            throw new IOException(String.format("Could not find schema with id %s in registry", schemaId), e);
        }
    }

    @Override
    public void writeSchema(Schema schema, OutputStream out) throws IOException {
        try {
            int registeredId = this.schemaRegistryClient.register(this.subject, schema);
            out.write(0);
            byte[] schemaIdBytes = ByteBuffer.allocate(4).putInt(registeredId).array();
            out.write(schemaIdBytes);
        }
        catch (RestClientException e) {
            throw new IOException("Could not register schema in registry", e);
        }
    }
}

