/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class UpdateFeaturesRequestData
implements ApiMessage {
    int timeoutMs;
    FeatureUpdateKeyCollection featureUpdates;
    boolean validateOnly;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("timeout_ms", Type.INT32, "How long to wait in milliseconds before timing out the request."), new Field("feature_updates", new CompactArrayOf(FeatureUpdateKey.SCHEMA_0), "The list of updates to finalized features."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("timeout_ms", Type.INT32, "How long to wait in milliseconds before timing out the request."), new Field("feature_updates", new CompactArrayOf(FeatureUpdateKey.SCHEMA_1), "The list of updates to finalized features."), new Field("validate_only", Type.BOOLEAN, "True if we should validate the request, but not perform the upgrade or downgrade."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public UpdateFeaturesRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public UpdateFeaturesRequestData() {
        this.timeoutMs = 60000;
        this.featureUpdates = new FeatureUpdateKeyCollection(0);
        this.validateOnly = false;
    }

    @Override
    public short apiKey() {
        return 57;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.timeoutMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field featureUpdates was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        FeatureUpdateKeyCollection newCollection = new FeatureUpdateKeyCollection(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new FeatureUpdateKey(_readable, _version));
        }
        this.featureUpdates = newCollection;
        this.validateOnly = _version >= 1 ? _readable.readByte() != 0 : false;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.timeoutMs);
        _writable.writeUnsignedVarint(this.featureUpdates.size() + 1);
        for (FeatureUpdateKey featureUpdatesElement : this.featureUpdates) {
            featureUpdatesElement.write(_writable, _cache, _version);
        }
        if (_version >= 1) {
            _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        } else if (this.validateOnly) {
            throw new UnsupportedVersionException("Attempted to write a non-default validateOnly at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.featureUpdates.size() + 1));
        for (FeatureUpdateKey featureUpdatesElement : this.featureUpdates) {
            featureUpdatesElement.addSize(_size, _cache, _version);
        }
        if (_version >= 1) {
            _size.addBytes(1);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdateFeaturesRequestData)) {
            return false;
        }
        UpdateFeaturesRequestData other = (UpdateFeaturesRequestData)obj;
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.featureUpdates == null ? other.featureUpdates != null : !this.featureUpdates.equals(other.featureUpdates)) {
            return false;
        }
        if (this.validateOnly != other.validateOnly) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.featureUpdates == null ? 0 : this.featureUpdates.hashCode());
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public UpdateFeaturesRequestData duplicate() {
        UpdateFeaturesRequestData _duplicate = new UpdateFeaturesRequestData();
        _duplicate.timeoutMs = this.timeoutMs;
        FeatureUpdateKeyCollection newFeatureUpdates = new FeatureUpdateKeyCollection(this.featureUpdates.size());
        for (FeatureUpdateKey _element : this.featureUpdates) {
            newFeatureUpdates.add(_element.duplicate());
        }
        _duplicate.featureUpdates = newFeatureUpdates;
        _duplicate.validateOnly = this.validateOnly;
        return _duplicate;
    }

    public String toString() {
        return "UpdateFeaturesRequestData(timeoutMs=" + this.timeoutMs + ", featureUpdates=" + MessageUtil.deepToString(this.featureUpdates.iterator()) + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ")";
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public FeatureUpdateKeyCollection featureUpdates() {
        return this.featureUpdates;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public UpdateFeaturesRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public UpdateFeaturesRequestData setFeatureUpdates(FeatureUpdateKeyCollection v) {
        this.featureUpdates = v;
        return this;
    }

    public UpdateFeaturesRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    public static class FeatureUpdateKeyCollection
    extends ImplicitLinkedHashMultiCollection<FeatureUpdateKey> {
        public FeatureUpdateKeyCollection() {
        }

        public FeatureUpdateKeyCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public FeatureUpdateKeyCollection(Iterator<FeatureUpdateKey> iterator) {
            super(iterator);
        }

        @Override
        public FeatureUpdateKey find(String feature) {
            FeatureUpdateKey _key = new FeatureUpdateKey();
            _key.setFeature(feature);
            return this.find(_key);
        }

        @Override
        public List<FeatureUpdateKey> findAll(String feature) {
            FeatureUpdateKey _key = new FeatureUpdateKey();
            _key.setFeature(feature);
            return this.findAll(_key);
        }

        public FeatureUpdateKeyCollection duplicate() {
            FeatureUpdateKeyCollection _duplicate = new FeatureUpdateKeyCollection(this.size());
            for (FeatureUpdateKey _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class FeatureUpdateKey
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String feature;
        short maxVersionLevel;
        boolean allowDowngrade;
        byte upgradeType;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("feature", Type.COMPACT_STRING, "The name of the finalized feature to be updated."), new Field("max_version_level", Type.INT16, "The new maximum version level for the finalized feature. A value >= 1 is valid. A value < 1, is special, and can be used to request the deletion of the finalized feature."), new Field("allow_downgrade", Type.BOOLEAN, "DEPRECATED in version 1 (see DowngradeType). When set to true, the finalized feature version level is allowed to be downgraded/deleted. The downgrade request will fail if the new maximum version level is a value that's not lower than the existing maximum finalized version level."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("feature", Type.COMPACT_STRING, "The name of the finalized feature to be updated."), new Field("max_version_level", Type.INT16, "The new maximum version level for the finalized feature. A value >= 1 is valid. A value < 1, is special, and can be used to request the deletion of the finalized feature."), new Field("upgrade_type", Type.INT8, "Determine which type of upgrade will be performed: 1 will perform an upgrade only (default), 2 is safe downgrades only (lossless), 3 is unsafe downgrades (lossy)."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public FeatureUpdateKey(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public FeatureUpdateKey() {
            this.feature = "";
            this.maxVersionLevel = 0;
            this.allowDowngrade = false;
            this.upgradeType = 1;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FeatureUpdateKey");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field feature was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field feature had invalid length " + length);
            }
            this.feature = _readable.readString(length);
            this.maxVersionLevel = _readable.readShort();
            this.allowDowngrade = _version <= 0 ? _readable.readByte() != 0 : false;
            this.upgradeType = _version >= 1 ? _readable.readByte() : (byte)1;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.feature);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.maxVersionLevel);
            if (_version <= 0) {
                _writable.writeByte(this.allowDowngrade ? (byte)1 : 0);
            } else if (this.allowDowngrade) {
                throw new UnsupportedVersionException("Attempted to write a non-default allowDowngrade at version " + _version);
            }
            if (_version >= 1) {
                _writable.writeByte(this.upgradeType);
            } else if (this.upgradeType != 1) {
                throw new UnsupportedVersionException("Attempted to write a non-default upgradeType at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of FeatureUpdateKey");
            }
            byte[] _stringBytes = this.feature.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'feature' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.feature, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            if (_version <= 0) {
                _size.addBytes(1);
            }
            if (_version >= 1) {
                _size.addBytes(1);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof FeatureUpdateKey)) {
                return false;
            }
            FeatureUpdateKey other = (FeatureUpdateKey)obj;
            return !(this.feature == null ? other.feature != null : !this.feature.equals(other.feature));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FeatureUpdateKey)) {
                return false;
            }
            FeatureUpdateKey other = (FeatureUpdateKey)obj;
            if (this.feature == null ? other.feature != null : !this.feature.equals(other.feature)) {
                return false;
            }
            if (this.maxVersionLevel != other.maxVersionLevel) {
                return false;
            }
            if (this.allowDowngrade != other.allowDowngrade) {
                return false;
            }
            if (this.upgradeType != other.upgradeType) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.feature == null ? 0 : this.feature.hashCode());
            return hashCode;
        }

        @Override
        public FeatureUpdateKey duplicate() {
            FeatureUpdateKey _duplicate = new FeatureUpdateKey();
            _duplicate.feature = this.feature;
            _duplicate.maxVersionLevel = this.maxVersionLevel;
            _duplicate.allowDowngrade = this.allowDowngrade;
            _duplicate.upgradeType = this.upgradeType;
            return _duplicate;
        }

        public String toString() {
            return "FeatureUpdateKey(feature=" + (this.feature == null ? "null" : "'" + this.feature.toString() + "'") + ", maxVersionLevel=" + this.maxVersionLevel + ", allowDowngrade=" + (this.allowDowngrade ? "true" : "false") + ", upgradeType=" + this.upgradeType + ")";
        }

        public String feature() {
            return this.feature;
        }

        public short maxVersionLevel() {
            return this.maxVersionLevel;
        }

        public boolean allowDowngrade() {
            return this.allowDowngrade;
        }

        public byte upgradeType() {
            return this.upgradeType;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public FeatureUpdateKey setFeature(String v) {
            this.feature = v;
            return this;
        }

        public FeatureUpdateKey setMaxVersionLevel(short v) {
            this.maxVersionLevel = v;
            return this;
        }

        public FeatureUpdateKey setAllowDowngrade(boolean v) {
            this.allowDowngrade = v;
            return this;
        }

        public FeatureUpdateKey setUpgradeType(byte v) {
            this.upgradeType = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }
}

