/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.admin;

import java.util.Objects;

public class FinalizedVersionRange {
    private final short minVersionLevel;
    private final short maxVersionLevel;

    FinalizedVersionRange(short minVersionLevel, short maxVersionLevel) {
        if (minVersionLevel < 0 || maxVersionLevel < 0 || maxVersionLevel < minVersionLevel) {
            throw new IllegalArgumentException(String.format("Expected minVersionLevel >= 0, maxVersionLevel >= 0 and maxVersionLevel >= minVersionLevel, but received minVersionLevel: %d, maxVersionLevel: %d", minVersionLevel, maxVersionLevel));
        }
        this.minVersionLevel = minVersionLevel;
        this.maxVersionLevel = maxVersionLevel;
    }

    public short minVersionLevel() {
        return this.minVersionLevel;
    }

    public short maxVersionLevel() {
        return this.maxVersionLevel;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FinalizedVersionRange)) {
            return false;
        }
        FinalizedVersionRange that = (FinalizedVersionRange)other;
        return this.minVersionLevel == that.minVersionLevel && this.maxVersionLevel == that.maxVersionLevel;
    }

    public int hashCode() {
        return Objects.hash(this.minVersionLevel, this.maxVersionLevel);
    }

    public String toString() {
        return String.format("FinalizedVersionRange[min_version_level:%d, max_version_level:%d]", this.minVersionLevel, this.maxVersionLevel);
    }
}

