/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.metrics;

import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.Metric;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.MetricName;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.metrics.Gauge;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.metrics.Measurable;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.metrics.MetricConfig;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.Time;

public final class KafkaMetric
implements Metric {
    private MetricName metricName;
    private final Object lock;
    private final Time time;
    private final MetricValueProvider<?> metricValueProvider;
    private MetricConfig config;

    public KafkaMetric(Object lock, MetricName metricName, MetricValueProvider<?> valueProvider, MetricConfig config, Time time) {
        this.metricName = metricName;
        this.lock = lock;
        if (!(valueProvider instanceof Measurable) && !(valueProvider instanceof Gauge)) {
            throw new IllegalArgumentException("Unsupported metric value provider of class " + valueProvider.getClass());
        }
        this.metricValueProvider = valueProvider;
        this.config = config;
        this.time = time;
    }

    public MetricConfig config() {
        return this.config;
    }

    @Override
    public MetricName metricName() {
        return this.metricName;
    }

    @Override
    public Object metricValue() {
        long now = this.time.milliseconds();
        Object object = this.lock;
        synchronized (object) {
            if (this.metricValueProvider instanceof Measurable) {
                return ((Measurable)this.metricValueProvider).measure(this.config, now);
            }
            if (this.metricValueProvider instanceof Gauge) {
                return ((Gauge)this.metricValueProvider).value(this.config, now);
            }
            throw new IllegalStateException("Not a valid metric: " + this.metricValueProvider.getClass());
        }
    }

    public Measurable measurable() {
        if (this.metricValueProvider instanceof Measurable) {
            return (Measurable)this.metricValueProvider;
        }
        throw new IllegalStateException("Not a measurable: " + this.metricValueProvider.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double measurableValue(long timeMs) {
        Object object = this.lock;
        synchronized (object) {
            if (this.metricValueProvider instanceof Measurable) {
                return ((Measurable)this.metricValueProvider).measure(this.config, timeMs);
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void config(MetricConfig config) {
        Object object = this.lock;
        synchronized (object) {
            this.config = config;
        }
    }
}

