/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericRecord;
import org.apache.flink.formats.avro.typeutils.AvroSerializer;
import org.apache.flink.util.Preconditions;

public class GenericRecordAvroTypeInfo
extends TypeInformation<GenericRecord> {
    private static final long serialVersionUID = 4141977586453820650L;
    private transient Schema schema;

    public GenericRecordAvroTypeInfo(Schema schema) {
        this.schema = (Schema)Preconditions.checkNotNull((Object)schema);
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<GenericRecord> getTypeClass() {
        return GenericRecord.class;
    }

    public boolean isKeyType() {
        return false;
    }

    public TypeSerializer<GenericRecord> createSerializer(ExecutionConfig config) {
        return new AvroSerializer<GenericRecord>(GenericRecord.class, this.schema);
    }

    public String toString() {
        return String.format("GenericRecord(\"%s\")", this.schema.toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof GenericRecordAvroTypeInfo) {
            GenericRecordAvroTypeInfo avroTypeInfo = (GenericRecordAvroTypeInfo)((Object)obj);
            return Objects.equals(avroTypeInfo.schema, this.schema);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.schema);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof GenericRecordAvroTypeInfo;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        byte[] schemaStrInBytes = this.schema.toString(false).getBytes(StandardCharsets.UTF_8);
        oos.writeInt(schemaStrInBytes.length);
        oos.write(schemaStrInBytes);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        int len = ois.readInt();
        byte[] content = new byte[len];
        ois.readFully(content);
        this.schema = new Schema.Parser().parse(new String(content, StandardCharsets.UTF_8));
    }
}

