/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericDatumReader;
import org.apache.flink.formats.avro.AvroDeserializationSchema;
import org.apache.flink.formats.avro.SchemaCoder;

public class RegistryAvroDeserializationSchema<T>
extends AvroDeserializationSchema<T> {
    private static final long serialVersionUID = -884738268437806062L;
    private final SchemaCoder.SchemaCoderProvider schemaCoderProvider;
    private transient SchemaCoder schemaCoder;

    public RegistryAvroDeserializationSchema(Class<T> recordClazz, @Nullable Schema reader, SchemaCoder.SchemaCoderProvider schemaCoderProvider) {
        super(recordClazz, reader);
        this.schemaCoderProvider = schemaCoderProvider;
        this.schemaCoder = schemaCoderProvider.get();
    }

    @Override
    public T deserialize(@Nullable byte[] message) throws IOException {
        if (message == null) {
            return null;
        }
        this.checkAvroInitialized();
        this.getInputStream().setBuffer(message);
        Schema writerSchema = this.schemaCoder.readSchema(this.getInputStream());
        Schema readerSchema = this.getReaderSchema();
        GenericDatumReader datumReader = this.getDatumReader();
        datumReader.setSchema(writerSchema);
        datumReader.setExpected(readerSchema);
        return datumReader.read(null, this.getDecoder());
    }

    @Override
    void checkAvroInitialized() {
        super.checkAvroInitialized();
        if (this.schemaCoder == null) {
            this.schemaCoder = this.schemaCoderProvider.get();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegistryAvroDeserializationSchema that = (RegistryAvroDeserializationSchema)o;
        return this.schemaCoderProvider.equals(that.schemaCoderProvider);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.schemaCoderProvider);
    }
}

