/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.ApiError;

public class UpdateFeaturesResponse
extends AbstractResponse {
    private final UpdateFeaturesResponseData data;

    public UpdateFeaturesResponse(UpdateFeaturesResponseData data) {
        super(ApiKeys.UPDATE_FEATURES);
        this.data = data;
    }

    public ApiError topLevelError() {
        return new ApiError(Errors.forCode(this.data.errorCode()), this.data.errorMessage());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.updateErrorCounts(errorCounts, Errors.forCode(this.data.errorCode()));
        for (UpdateFeaturesResponseData.UpdatableFeatureResult result : this.data.results()) {
            this.updateErrorCounts(errorCounts, Errors.forCode(result.errorCode()));
        }
        return errorCounts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public UpdateFeaturesResponseData data() {
        return this.data;
    }

    public static UpdateFeaturesResponse parse(ByteBuffer buffer, short version) {
        return new UpdateFeaturesResponse(new UpdateFeaturesResponseData(new ByteBufferAccessor(buffer), version));
    }

    public static UpdateFeaturesResponse createWithErrors(ApiError topLevelError, Map<String, ApiError> updateErrors, int throttleTimeMs) {
        UpdateFeaturesResponseData.UpdatableFeatureResultCollection results = new UpdateFeaturesResponseData.UpdatableFeatureResultCollection();
        for (Map.Entry<String, ApiError> updateError : updateErrors.entrySet()) {
            String feature = updateError.getKey();
            ApiError error = updateError.getValue();
            UpdateFeaturesResponseData.UpdatableFeatureResult result = new UpdateFeaturesResponseData.UpdatableFeatureResult();
            result.setFeature(feature).setErrorCode(error.error().code()).setErrorMessage(error.message());
            results.add(result);
        }
        UpdateFeaturesResponseData responseData = new UpdateFeaturesResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(topLevelError.error().code()).setErrorMessage(topLevelError.message()).setResults(results).setThrottleTimeMs(throttleTimeMs);
        return new UpdateFeaturesResponse(responseData);
    }
}

