/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.internals.Topic;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.JoinGroupResponse;

public class JoinGroupRequest
extends AbstractRequest {
    private final JoinGroupRequestData data;
    public static final String UNKNOWN_MEMBER_ID = "";
    public static final int UNKNOWN_GENERATION_ID = -1;
    public static final String UNKNOWN_PROTOCOL_NAME = "";

    public static void validateGroupInstanceId(String id) {
        Topic.validate(id, "Group instance id", message -> {
            throw new InvalidConfigurationException((String)message);
        });
    }

    public static String maybeTruncateReason(String reason) {
        if (reason.length() > 255) {
            return reason.substring(0, 255);
        }
        return reason;
    }

    public JoinGroupRequest(JoinGroupRequestData data, short version) {
        super(ApiKeys.JOIN_GROUP, version);
        this.data = data;
        this.maybeOverrideRebalanceTimeout(version);
    }

    private void maybeOverrideRebalanceTimeout(short version) {
        if (version == 0) {
            this.data.setRebalanceTimeoutMs(this.data.sessionTimeoutMs());
        }
    }

    @Override
    public JoinGroupRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        JoinGroupResponseData data = new JoinGroupResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()).setGenerationId(-1).setProtocolName("").setLeader("").setMemberId("").setMembers(Collections.emptyList());
        if (this.version() >= 7) {
            data.setProtocolName(null);
        } else {
            data.setProtocolName("");
        }
        return new JoinGroupResponse(data);
    }

    public static JoinGroupRequest parse(ByteBuffer buffer, short version) {
        return new JoinGroupRequest(new JoinGroupRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<JoinGroupRequest> {
        private final JoinGroupRequestData data;

        public Builder(JoinGroupRequestData data) {
            super(ApiKeys.JOIN_GROUP);
            this.data = data;
        }

        @Override
        public JoinGroupRequest build(short version) {
            if (this.data.groupInstanceId() != null && version < 5) {
                throw new UnsupportedVersionException("The broker join group protocol version " + version + " does not support usage of config group.instance.id.");
            }
            return new JoinGroupRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

