/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.compress;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.RecyclingBufferPool;
import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import com.github.luben.zstd.ZstdOutputStreamNoFinalizer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.BufferSupplier;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ByteBufferOutputStream;

public class ZstdFactory {
    private ZstdFactory() {
    }

    public static OutputStream wrapForOutput(ByteBufferOutputStream buffer) {
        try {
            return new BufferedOutputStream(new ZstdOutputStreamNoFinalizer((OutputStream)buffer, RecyclingBufferPool.INSTANCE), 16384);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }

    public static InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, final BufferSupplier decompressionBufferSupplier) {
        try {
            BufferPool bufferPool = new BufferPool(){

                @Override
                public ByteBuffer get(int capacity) {
                    return decompressionBufferSupplier.get(capacity);
                }

                @Override
                public void release(ByteBuffer buffer) {
                    decompressionBufferSupplier.release(buffer);
                }
            };
            return new BufferedInputStream(new ZstdInputStreamNoFinalizer(new ByteBufferInputStream(buffer), bufferPool), 16384);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }
}

