/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.requests;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Config update request")
public class ConfigUpdateRequest {
    private String compatibilityLevel;

    public static ConfigUpdateRequest fromJson(String json) throws IOException {
        return JacksonMapper.INSTANCE.readValue(json, ConfigUpdateRequest.class);
    }

    @Schema(description="Compatibility Level", allowableValues={"BACKWARD, BACKWARD_TRANSITIVE, FORWARD, FORWARD_TRANSITIVE, FULL, FULL_TRANSITIVE, NONE"})
    @JsonProperty(value="compatibility")
    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    @JsonProperty(value="compatibility")
    public void setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigUpdateRequest that = (ConfigUpdateRequest)o;
        return Objects.equals(this.compatibilityLevel, that.compatibilityLevel);
    }

    public int hashCode() {
        return Objects.hash(this.compatibilityLevel);
    }
}

