/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router;

import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.QueryStringDecoder;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.DualMethodRouter;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.KeepAliveWrite;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.Routed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
public abstract class DualAbstractHandler<T, RouteLike extends DualMethodRouter<T, RouteLike>>
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final byte[] CONTENT_404 = "Not Found".getBytes();
    private final DualMethodRouter<T, RouteLike> router;

    public DualAbstractHandler(DualMethodRouter<T, RouteLike> dualMethodRouter) {
        this.router = dualMethodRouter;
    }

    public DualMethodRouter<T, RouteLike> router() {
        return this.router;
    }

    protected abstract void routed(ChannelHandlerContext var1, Routed var2) throws Exception;

    @Override
    protected void channelRead0(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest) throws Exception {
        QueryStringDecoder queryStringDecoder;
        if (HttpHeaders.is100ContinueExpected(httpRequest)) {
            channelHandlerContext.writeAndFlush(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            return;
        }
        HttpMethod httpMethod = httpRequest.getMethod();
        org.apache.flink.shaded.netty4.jauter.Routed<Object> routed = this.router.route(httpMethod, (queryStringDecoder = new QueryStringDecoder(httpRequest.getUri())).path());
        if (routed == null) {
            this.respondNotFound(channelHandlerContext, httpRequest);
            return;
        }
        Routed routed2 = new Routed(routed.target(), routed.notFound(), httpRequest, queryStringDecoder.path(), routed.params(), queryStringDecoder.parameters());
        this.routed(channelHandlerContext, routed2);
    }

    protected void respondNotFound(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND, Unpooled.wrappedBuffer(CONTENT_404));
        HttpHeaders httpHeaders = defaultFullHttpResponse.headers();
        httpHeaders.set("Content-Type", (Object)"text/plain");
        httpHeaders.set("Content-Length", (Object)CONTENT_404.length);
        KeepAliveWrite.flush(channelHandlerContext, httpRequest, (HttpResponse)defaultFullHttpResponse);
    }
}

