/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.netty4.io.netty.channel.epoll;

import org.apache.flink.shaded.netty4.io.netty.buffer.CompositeByteBuf;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelOutboundBuffer;
import org.apache.flink.shaded.netty4.io.netty.channel.epoll.IovArray;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.FastThreadLocal;

final class IovArrayThreadLocal {
    private static final FastThreadLocal<IovArray> ARRAY = new FastThreadLocal<IovArray>(){

        @Override
        protected IovArray initialValue() throws Exception {
            return new IovArray();
        }

        @Override
        protected void onRemoval(IovArray value) throws Exception {
            value.release();
        }
    };

    static IovArray get(ChannelOutboundBuffer buffer) throws Exception {
        IovArray array = ARRAY.get();
        array.clear();
        buffer.forEachFlushedMessage(array);
        return array;
    }

    static IovArray get(CompositeByteBuf buf) throws Exception {
        IovArray array = ARRAY.get();
        array.clear();
        array.add(buf);
        return array;
    }

    private IovArrayThreadLocal() {
    }
}

