/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.sequencefile;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;

@PublicEvolving
public class SequenceFileWriter<K extends Writable, V extends Writable>
implements BulkWriter<Tuple2<K, V>> {
    private final SequenceFile.Writer writer;

    SequenceFileWriter(SequenceFile.Writer writer) {
        this.writer = (SequenceFile.Writer)Preconditions.checkNotNull((Object)writer);
    }

    public void addElement(Tuple2<K, V> element) throws IOException {
        this.writer.append((Writable)element.f0, (Writable)element.f1);
    }

    public void flush() throws IOException {
        this.writer.hsync();
    }

    public void finish() throws IOException {
        this.writer.close();
    }
}

