/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.sequencefile;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.formats.sequencefile.SequenceFileWriter;
import org.apache.flink.formats.sequencefile.SerializableHadoopConfiguration;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;

@PublicEvolving
public class SequenceFileWriterFactory<K extends Writable, V extends Writable>
implements BulkWriter.Factory<Tuple2<K, V>> {
    private static final long serialVersionUID = 1L;
    public static final String NO_COMPRESSION = "NO_COMPRESSION";
    private final SerializableHadoopConfiguration serializableHadoopConfig;
    private final Class<K> keyClass;
    private final Class<V> valueClass;
    private final String compressionCodecName;
    private final SequenceFile.CompressionType compressionType;

    public SequenceFileWriterFactory(Configuration hadoopConf, Class<K> keyClass, Class<V> valueClass) {
        this(hadoopConf, keyClass, valueClass, NO_COMPRESSION, SequenceFile.CompressionType.BLOCK);
    }

    public SequenceFileWriterFactory(Configuration hadoopConf, Class<K> keyClass, Class<V> valueClass, String compressionCodecName) {
        this(hadoopConf, keyClass, valueClass, compressionCodecName, SequenceFile.CompressionType.BLOCK);
    }

    public SequenceFileWriterFactory(Configuration hadoopConf, Class<K> keyClass, Class<V> valueClass, String compressionCodecName, SequenceFile.CompressionType compressionType) {
        this.serializableHadoopConfig = new SerializableHadoopConfiguration((Configuration)Preconditions.checkNotNull((Object)hadoopConf));
        this.keyClass = (Class)Preconditions.checkNotNull(keyClass);
        this.valueClass = (Class)Preconditions.checkNotNull(valueClass);
        this.compressionCodecName = (String)Preconditions.checkNotNull((Object)compressionCodecName);
        this.compressionType = (SequenceFile.CompressionType)Preconditions.checkNotNull((Object)compressionType);
    }

    public SequenceFileWriter<K, V> create(org.apache.flink.core.fs.FSDataOutputStream out) throws IOException {
        FSDataOutputStream stream = new FSDataOutputStream((OutputStream)out, null);
        CompressionCodec compressionCodec = this.getCompressionCodec(this.serializableHadoopConfig.get(), this.compressionCodecName);
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)this.serializableHadoopConfig.get(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.stream((FSDataOutputStream)stream), SequenceFile.Writer.keyClass(this.keyClass), SequenceFile.Writer.valueClass(this.valueClass), SequenceFile.Writer.compression((SequenceFile.CompressionType)this.compressionType, (CompressionCodec)compressionCodec)});
        return new SequenceFileWriter(writer);
    }

    private CompressionCodec getCompressionCodec(Configuration conf, String compressionCodecName) {
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkNotNull((Object)compressionCodecName);
        if (compressionCodecName.equals(NO_COMPRESSION)) {
            return null;
        }
        CompressionCodecFactory codecFactory = new CompressionCodecFactory(conf);
        CompressionCodec codec = codecFactory.getCodecByName(compressionCodecName);
        if (codec == null) {
            throw new RuntimeException("Codec " + compressionCodecName + " not found.");
        }
        return codec;
    }
}

