/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink.committables;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.metrics.groups.SinkCommitterMetricGroup;
import org.apache.flink.streaming.runtime.operators.sink.committables.CommitRequestState;

@Internal
public class CommitRequestImpl<CommT>
implements Committer.CommitRequest<CommT> {
    private CommT committable;
    private int numRetries;
    private CommitRequestState state;
    private SinkCommitterMetricGroup metricGroup;

    protected CommitRequestImpl(CommT committable, SinkCommitterMetricGroup metricGroup) {
        this.committable = committable;
        this.metricGroup = metricGroup;
        this.state = CommitRequestState.RECEIVED;
    }

    protected CommitRequestImpl(CommT committable, int numRetries, CommitRequestState state, SinkCommitterMetricGroup metricGroup) {
        this.committable = committable;
        this.numRetries = numRetries;
        this.state = state;
        this.metricGroup = metricGroup;
    }

    boolean isFinished() {
        return this.state.isFinalState();
    }

    CommitRequestState getState() {
        return this.state;
    }

    public CommT getCommittable() {
        return this.committable;
    }

    public int getNumberOfRetries() {
        return this.numRetries;
    }

    public void signalFailedWithKnownReason(Throwable t) {
        this.state = CommitRequestState.FAILED;
        this.metricGroup.getNumCommittablesFailureCounter().inc();
    }

    public void signalFailedWithUnknownReason(Throwable t) {
        this.state = CommitRequestState.FAILED;
        this.metricGroup.getNumCommittablesFailureCounter().inc();
        throw new IllegalStateException("Failed to commit " + String.valueOf(this.committable), t);
    }

    public void retryLater() {
        this.state = CommitRequestState.RETRY;
        ++this.numRetries;
        this.metricGroup.getNumCommittablesRetryCounter().inc();
    }

    public void updateAndRetryLater(CommT committable) {
        this.committable = committable;
        this.retryLater();
    }

    public void signalAlreadyCommitted() {
        this.state = CommitRequestState.COMMITTED;
        this.metricGroup.getNumCommittablesAlreadyCommittedCounter().inc();
    }

    void setSelected() {
        this.state = CommitRequestState.RECEIVED;
    }

    void setCommittedIfNoError() {
        if (this.state == CommitRequestState.RECEIVED) {
            this.state = CommitRequestState.COMMITTED;
            this.metricGroup.getNumCommittablesSuccessCounter().inc();
        }
    }

    CommitRequestImpl<CommT> copy() {
        return new CommitRequestImpl<CommT>(this.committable, this.numRetries, this.state, this.metricGroup);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitRequestImpl that = (CommitRequestImpl)o;
        return this.numRetries == that.numRetries && Objects.equals(this.committable, that.committable) && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.committable, this.numRetries, this.state});
    }

    public String toString() {
        return "CommitRequestImpl{state=" + String.valueOf((Object)this.state) + ", numRetries=" + this.numRetries + ", committable=" + String.valueOf(this.committable) + "}";
    }
}

