/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.time.Duration;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.streaming.api.functions.source.legacy.SourceFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.LatencyMarkerEmitter;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamSourceContexts;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.OperatorChain;

@Deprecated
@Internal
public class StreamSource<OUT, SRC extends SourceFunction<OUT>>
extends AbstractUdfStreamOperator<OUT, SRC> {
    private static final long serialVersionUID = 1L;
    private final boolean emitProgressiveWatermarks;
    private transient SourceFunction.SourceContext<OUT> ctx;
    private volatile transient boolean canceledOrStopped = false;

    public StreamSource(SRC sourceFunction, boolean emitProgressiveWatermarks) {
        super(sourceFunction);
        this.emitProgressiveWatermarks = emitProgressiveWatermarks;
    }

    public StreamSource(SRC sourceFunction) {
        this(sourceFunction, true);
    }

    @VisibleForTesting
    public boolean emitsProgressiveWatermarks() {
        return this.emitProgressiveWatermarks;
    }

    public void run(Object lockingObject, OperatorChain<?, ?> operatorChain) throws Exception {
        this.run(lockingObject, this.output, operatorChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Object lockingObject, Output<StreamRecord<OUT>> collector, OperatorChain<?, ?> operatorChain) throws Exception {
        Configuration configuration = this.getContainingTask().getEnvironment().getTaskManagerInfo().getConfiguration();
        long latencyTrackingInterval = this.getExecutionConfig().isLatencyTrackingConfigured() ? this.getExecutionConfig().getLatencyTrackingInterval() : ((Duration)configuration.get(MetricOptions.LATENCY_INTERVAL)).toMillis();
        LatencyMarkerEmitter latencyEmitter = null;
        if (latencyTrackingInterval > 0L) {
            latencyEmitter = new LatencyMarkerEmitter(this.getProcessingTimeService(), collector::emitLatencyMarker, latencyTrackingInterval, this.getOperatorID(), this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask());
        }
        long watermarkInterval = this.getExecutionConfig().getAutoWatermarkInterval();
        this.ctx = StreamSourceContexts.getSourceContext(this.getProcessingTimeService(), lockingObject, collector, watermarkInterval, -1L, this.emitProgressiveWatermarks);
        try {
            ((SourceFunction)this.userFunction).run(this.ctx);
        }
        finally {
            if (latencyEmitter != null) {
                latencyEmitter.close();
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this.ctx != null) {
            this.ctx.close();
        }
        super.close();
    }

    public void stop() {
        ((SourceFunction)this.userFunction).cancel();
    }

    public void cancel() {
        this.markCanceledOrStopped();
        ((SourceFunction)this.userFunction).cancel();
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    protected void markCanceledOrStopped() {
        this.canceledOrStopped = true;
    }

    protected boolean isCanceledOrStopped() {
        return this.canceledOrStopped;
    }
}

