/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.state.ttl.TtlUtils;
import org.apache.flink.runtime.state.ttl.TtlValue;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.ThrowingRunnable;

public abstract class AbstractTtlDecorator<T> {
    protected final T original;
    protected final StateTtlConfig config;
    protected final TtlTimeProvider timeProvider;
    protected final boolean updateTsOnRead;
    protected final boolean returnExpired;
    protected final long ttl;

    protected AbstractTtlDecorator(T original, StateTtlConfig config, TtlTimeProvider timeProvider) {
        Preconditions.checkNotNull(original);
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)timeProvider);
        this.original = original;
        this.config = config;
        this.timeProvider = timeProvider;
        this.updateTsOnRead = config.getUpdateType() == StateTtlConfig.UpdateType.OnReadAndWrite;
        this.returnExpired = config.getStateVisibility() == StateTtlConfig.StateVisibility.ReturnExpiredIfNotCleanedUp;
        this.ttl = config.getTimeToLive().toMillis();
    }

    public <V> V getUnexpired(TtlValue<V> ttlValue) {
        return ttlValue == null || !this.returnExpired && this.expired(ttlValue) ? null : (V)ttlValue.getUserValue();
    }

    public <V> boolean expired(TtlValue<V> ttlValue) {
        return TtlUtils.expired(ttlValue, this.ttl, this.timeProvider);
    }

    public <V> TtlValue<V> wrapWithTs(V value) {
        return TtlUtils.wrapWithTs(value, this.timeProvider.currentTimestamp());
    }

    public <V> TtlValue<V> rewrapWithNewTs(TtlValue<V> ttlValue) {
        return this.wrapWithTs(ttlValue.getUserValue());
    }

    public <SE extends Throwable, CE extends Throwable, CLE extends Throwable, V> V getWithTtlCheckAndUpdate(SupplierWithException<TtlValue<V>, SE> getter, ThrowingConsumer<TtlValue<V>, CE> updater, ThrowingRunnable<CLE> stateClear) throws SE, CE, CLE {
        TtlValue<V> ttlValue = this.getWrappedWithTtlCheckAndUpdate(getter, updater, stateClear);
        return ttlValue == null ? null : (V)ttlValue.getUserValue();
    }

    public <SE extends Throwable, CE extends Throwable, CLE extends Throwable, V> TtlValue<V> getWrappedWithTtlCheckAndUpdate(SupplierWithException<TtlValue<V>, SE> getter, ThrowingConsumer<TtlValue<V>, CE> updater, ThrowingRunnable<CLE> stateClear) throws SE, CE, CLE {
        TtlValue ttlValue = (TtlValue)getter.get();
        if (ttlValue == null) {
            return null;
        }
        if (this.expired(ttlValue)) {
            stateClear.run();
            if (!this.returnExpired) {
                return null;
            }
        } else if (this.updateTsOnRead) {
            updater.accept(this.rewrapWithNewTs(ttlValue));
        }
        return ttlValue;
    }

    protected <T> T getElementWithTtlCheck(TtlValue<T> ttlValue) {
        if (ttlValue == null) {
            return null;
        }
        if (this.expired(ttlValue) && !this.returnExpired) {
            return null;
        }
        return ttlValue.getUserValue();
    }
}

