/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileBasedStateOutputStream
extends CheckpointStateOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedStateOutputStream.class);
    private final FSDataOutputStream out;
    private final Path path;
    private final FileSystem fileSystem;
    private volatile boolean closed;

    public FileBasedStateOutputStream(FileSystem fileSystem, Path path) throws IOException {
        this.fileSystem = (FileSystem)Preconditions.checkNotNull((Object)fileSystem);
        this.path = (Path)Preconditions.checkNotNull((Object)path);
        this.out = fileSystem.create(path, FileSystem.WriteMode.NO_OVERWRITE);
    }

    public final void write(int b) throws IOException {
        this.out.write(b);
    }

    public final void write(@Nonnull byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public long getPos() throws IOException {
        return this.out.getPos();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void sync() throws IOException {
        this.out.sync();
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.out.close();
                this.fileSystem.delete(this.path, false);
            }
            catch (Throwable t) {
                LOG.warn("Could not close the state stream for {}.", (Object)this.path, (Object)t);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public FileStateHandle closeAndGetHandle() throws IOException {
        FileBasedStateOutputStream fileBasedStateOutputStream = this;
        synchronized (fileBasedStateOutputStream) {
            if (this.closed) throw new IOException("Stream has already been closed and discarded.");
            try {
                long size = 0L;
                try {
                    size = this.out.getPos();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.out.close();
                FileStateHandle fileStateHandle = new FileStateHandle(this.path, size);
                return fileStateHandle;
            }
            catch (Exception e) {
                try {
                    this.fileSystem.delete(this.path, false);
                    throw new IOException("Could not flush and close the file system output stream to " + String.valueOf(this.path) + " in order to obtain the stream state handle", e);
                }
                catch (Exception deleteException) {
                    LOG.warn("Could not delete the checkpoint stream file {}.", (Object)this.path, (Object)deleteException);
                }
                throw new IOException("Could not flush and close the file system output stream to " + String.valueOf(this.path) + " in order to obtain the stream state handle", e);
            }
            finally {
                this.closed = true;
            }
        }
    }
}

