/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.ArrayListSerializer;
import org.apache.flink.runtime.state.RegisteredOperatorStateBackendMetaInfo;
import org.apache.flink.util.Preconditions;

public final class PartitionableListState<S>
implements ListState<S> {
    private RegisteredOperatorStateBackendMetaInfo<S> stateMetaInfo;
    private final ArrayList<S> internalList;
    private ArrayListSerializer<S> internalListCopySerializer;

    PartitionableListState(RegisteredOperatorStateBackendMetaInfo<S> stateMetaInfo) {
        this(stateMetaInfo, new ArrayList());
    }

    private PartitionableListState(RegisteredOperatorStateBackendMetaInfo<S> stateMetaInfo, ArrayList<S> internalList) {
        this.stateMetaInfo = (RegisteredOperatorStateBackendMetaInfo)Preconditions.checkNotNull(stateMetaInfo);
        this.internalList = (ArrayList)Preconditions.checkNotNull(internalList);
        this.internalListCopySerializer = new ArrayListSerializer<S>(stateMetaInfo.getPartitionStateSerializer());
    }

    private PartitionableListState(PartitionableListState<S> toCopy) {
        this(toCopy.stateMetaInfo.deepCopy(), toCopy.internalListCopySerializer.copy(toCopy.internalList));
    }

    public void setStateMetaInfo(RegisteredOperatorStateBackendMetaInfo<S> stateMetaInfo) {
        this.internalListCopySerializer = new ArrayListSerializer<S>(stateMetaInfo.getPartitionStateSerializer());
        this.stateMetaInfo = stateMetaInfo;
    }

    public RegisteredOperatorStateBackendMetaInfo<S> getStateMetaInfo() {
        return this.stateMetaInfo;
    }

    public PartitionableListState<S> deepCopy() {
        return new PartitionableListState<S>(this);
    }

    public void clear() {
        this.internalList.clear();
    }

    public Iterable<S> get() {
        return this.internalList;
    }

    public void add(S value) {
        Preconditions.checkNotNull(value, (String)"You cannot add null to a ListState.");
        this.internalList.add(value);
    }

    public String toString() {
        return "PartitionableListState{stateMetaInfo=" + String.valueOf(this.stateMetaInfo) + ", internalList=" + String.valueOf(this.internalList) + "}";
    }

    public long[] write(FSDataOutputStream out) throws IOException {
        long[] partitionOffsets = new long[this.internalList.size()];
        DataOutputViewStreamWrapper dov = new DataOutputViewStreamWrapper((OutputStream)out);
        for (int i = 0; i < this.internalList.size(); ++i) {
            S element = this.internalList.get(i);
            partitionOffsets[i] = out.getPos();
            this.getStateMetaInfo().getPartitionStateSerializer().serialize(element, (DataOutputView)dov);
        }
        return partitionOffsets;
    }

    public void update(List<S> values) {
        this.internalList.clear();
        this.addAll(values);
    }

    public void addAll(List<S> values) {
        Preconditions.checkNotNull(values, (String)"List of values to add cannot be null.");
        if (!values.isEmpty()) {
            for (S value : values) {
                Preconditions.checkNotNull(value, (String)"Any value to add to a list cannot be null.");
                this.add(value);
            }
        }
    }

    @VisibleForTesting
    public ArrayListSerializer<S> getInternalListCopySerializer() {
        return this.internalListCopySerializer;
    }
}

