/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotTracker;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProvider;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequest;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalSlotProviderImpl
implements PhysicalSlotProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PhysicalSlotProviderImpl.class);
    private final SlotSelectionStrategy slotSelectionStrategy;
    private final SlotPool slotPool;

    public PhysicalSlotProviderImpl(SlotSelectionStrategy slotSelectionStrategy, SlotPool slotPool) {
        this.slotSelectionStrategy = (SlotSelectionStrategy)Preconditions.checkNotNull((Object)slotSelectionStrategy);
        this.slotPool = (SlotPool)Preconditions.checkNotNull((Object)slotPool);
    }

    @Override
    public void disableBatchSlotRequestTimeoutCheck() {
        this.slotPool.disableBatchSlotRequestTimeoutCheck();
    }

    @Override
    public Map<SlotRequestId, CompletableFuture<PhysicalSlotRequest.Result>> allocatePhysicalSlots(Collection<PhysicalSlotRequest> physicalSlotRequests) {
        this.logRequestInfo(physicalSlotRequests);
        Map physicalSlotRequestsById = physicalSlotRequests.stream().collect(Collectors.toMap(PhysicalSlotRequest::getSlotRequestId, Function.identity()));
        Map<SlotRequestId, Optional<PhysicalSlot>> availablePhysicalSlots = this.tryAllocateFromAvailable(physicalSlotRequestsById.values());
        return availablePhysicalSlots.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Optional availablePhysicalSlot = (Optional)entry.getValue();
            SlotRequestId slotRequestId = (SlotRequestId)((Object)((Object)entry.getKey()));
            PhysicalSlotRequest physicalSlotRequest = (PhysicalSlotRequest)physicalSlotRequestsById.get((Object)slotRequestId);
            SlotProfile slotProfile = physicalSlotRequest.getSlotProfile();
            CompletableFuture slotFuture = availablePhysicalSlot.map(CompletableFuture::completedFuture).orElseGet(() -> this.requestNewSlot(physicalSlotRequest));
            return slotFuture.thenApply(physicalSlot -> new PhysicalSlotRequest.Result(slotRequestId, (PhysicalSlot)physicalSlot));
        }));
    }

    private void logRequestInfo(Collection<PhysicalSlotRequest> physicalSlotRequests) {
        if (LOG.isDebugEnabled()) {
            for (PhysicalSlotRequest physicalSlotRequest : physicalSlotRequests) {
                LOG.debug("Received slot request [{}] with resource requirements: {}", (Object)physicalSlotRequest.getSlotRequestId(), (Object)physicalSlotRequest.getSlotProfile());
            }
        }
    }

    private Map<SlotRequestId, Optional<PhysicalSlot>> tryAllocateFromAvailable(Collection<PhysicalSlotRequest> slotRequests) {
        FreeSlotTracker freeSlotTracker = this.slotPool.getFreeSlotTracker();
        HashMap<SlotRequestId, Optional<PhysicalSlot>> allocateResult = new HashMap<SlotRequestId, Optional<PhysicalSlot>>();
        for (PhysicalSlotRequest request : slotRequests) {
            Optional<SlotSelectionStrategy.SlotInfoAndLocality> slot = this.slotSelectionStrategy.selectBestSlotForProfile(freeSlotTracker, request.getSlotProfile());
            allocateResult.put(request.getSlotRequestId(), slot.flatMap(slotInfoAndLocality -> {
                freeSlotTracker.reserveSlot(slotInfoAndLocality.getSlotInfo().getAllocationId());
                return this.slotPool.allocateAvailableSlot(slotInfoAndLocality.getSlotInfo().getAllocationId(), request);
            }));
        }
        return allocateResult;
    }

    private CompletableFuture<PhysicalSlot> requestNewSlot(PhysicalSlotRequest physicalSlotRequest) {
        if (physicalSlotRequest.willSlotBeOccupiedIndefinitely()) {
            return this.slotPool.requestNewAllocatedSlot(physicalSlotRequest, null);
        }
        return this.slotPool.requestNewAllocatedBatchSlot(physicalSlotRequest);
    }

    @Override
    public void cancelSlotRequest(SlotRequestId slotRequestId, Throwable cause) {
        this.slotPool.releaseSlot(slotRequestId, cause);
    }
}

