/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.checkpoint.JobManagerTaskRestore;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.util.GroupCache;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public final class TaskDeploymentDescriptor
implements Serializable {
    private static final long serialVersionUID = -3233562176034358530L;
    private final MaybeOffloaded<JobInformation> serializedJobInformation;
    private final MaybeOffloaded<TaskInformation> serializedTaskInformation;
    private transient JobInformation jobInformation;
    private transient TaskInformation taskInformation;
    @Nullable
    private final MaybeOffloaded<JobManagerTaskRestore> serializedTaskRestore;
    @Nullable
    private transient JobManagerTaskRestore taskRestore;
    private final JobID jobId;
    private final ExecutionAttemptID executionId;
    private final AllocationID allocationId;
    private final List<ResultPartitionDeploymentDescriptor> producedPartitions;
    private final List<InputGateDeploymentDescriptor> inputGates;

    public TaskDeploymentDescriptor(JobID jobId, MaybeOffloaded<JobInformation> serializedJobInformation, MaybeOffloaded<TaskInformation> serializedTaskInformation, ExecutionAttemptID executionAttemptId, AllocationID allocationId, @Nullable MaybeOffloaded<JobManagerTaskRestore> serializedTaskRestore, List<ResultPartitionDeploymentDescriptor> resultPartitionDeploymentDescriptors, List<InputGateDeploymentDescriptor> inputGateDeploymentDescriptors) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.serializedJobInformation = (MaybeOffloaded)Preconditions.checkNotNull(serializedJobInformation);
        this.serializedTaskInformation = (MaybeOffloaded)Preconditions.checkNotNull(serializedTaskInformation);
        this.executionId = (ExecutionAttemptID)Preconditions.checkNotNull((Object)executionAttemptId);
        this.allocationId = (AllocationID)((Object)Preconditions.checkNotNull((Object)((Object)allocationId)));
        this.serializedTaskRestore = serializedTaskRestore;
        this.producedPartitions = (List)Preconditions.checkNotNull(resultPartitionDeploymentDescriptors);
        this.inputGates = (List)Preconditions.checkNotNull(inputGateDeploymentDescriptors);
    }

    public JobInformation getJobInformation() throws IOException, ClassNotFoundException {
        if (this.jobInformation != null) {
            return this.jobInformation;
        }
        if (this.serializedJobInformation instanceof NonOffloaded) {
            NonOffloaded jobInformation = (NonOffloaded)this.serializedJobInformation;
            return (JobInformation)jobInformation.serializedValue.deserializeValue(this.getClass().getClassLoader());
        }
        throw new IllegalStateException("Trying to work with offloaded serialized job information.");
    }

    public TaskInformation getTaskInformation() throws IOException, ClassNotFoundException {
        if (this.taskInformation != null) {
            return this.taskInformation;
        }
        if (this.serializedTaskInformation instanceof NonOffloaded) {
            NonOffloaded taskInformation = (NonOffloaded)this.serializedTaskInformation;
            return (TaskInformation)taskInformation.serializedValue.deserializeValue(this.getClass().getClassLoader());
        }
        throw new IllegalStateException("Trying to work with offloaded serialized task information.");
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public ExecutionAttemptID getExecutionAttemptId() {
        return this.executionId;
    }

    public int getSubtaskIndex() {
        return this.executionId.getSubtaskIndex();
    }

    public int getAttemptNumber() {
        return this.executionId.getAttemptNumber();
    }

    public List<ResultPartitionDeploymentDescriptor> getProducedPartitions() {
        return this.producedPartitions;
    }

    public List<InputGateDeploymentDescriptor> getInputGates() {
        return this.inputGates;
    }

    @Nullable
    public JobManagerTaskRestore getTaskRestore() throws IOException, ClassNotFoundException {
        if (this.taskRestore != null || this.serializedTaskRestore == null) {
            return this.taskRestore;
        }
        if (this.serializedTaskRestore instanceof NonOffloaded) {
            NonOffloaded taskRestore = (NonOffloaded)this.serializedTaskRestore;
            return (JobManagerTaskRestore)taskRestore.serializedValue.deserializeValue(this.getClass().getClassLoader());
        }
        throw new IllegalStateException("Trying to work with offloaded serialized task restore.");
    }

    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public void loadBigData(@Nullable PermanentBlobService blobService, GroupCache<JobID, PermanentBlobKey, JobInformation> jobInformationCache, GroupCache<JobID, PermanentBlobKey, TaskInformation> taskInformationCache, GroupCache<JobID, PermanentBlobKey, TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> shuffleDescriptorsCache) throws IOException, ClassNotFoundException {
        File dataFile;
        if (this.serializedJobInformation instanceof Offloaded) {
            PermanentBlobKey jobInfoKey = ((Offloaded)this.serializedJobInformation).serializedValueKey;
            Preconditions.checkNotNull((Object)blobService);
            JobInformation jobInformation = jobInformationCache.get(this.jobId, jobInfoKey);
            if (jobInformation == null) {
                dataFile = blobService.getFile(this.jobId, jobInfoKey);
                jobInformation = (JobInformation)InstantiationUtil.deserializeObject((InputStream)new BufferedInputStream(Files.newInputStream(dataFile.toPath(), new OpenOption[0])), (ClassLoader)this.getClass().getClassLoader());
                jobInformationCache.put(this.jobId, jobInfoKey, jobInformation);
            }
            this.jobInformation = jobInformation.deepCopy();
        }
        if (this.serializedTaskInformation instanceof Offloaded) {
            PermanentBlobKey taskInfoKey = ((Offloaded)this.serializedTaskInformation).serializedValueKey;
            Preconditions.checkNotNull((Object)blobService);
            TaskInformation taskInformation = taskInformationCache.get(this.jobId, taskInfoKey);
            if (taskInformation == null) {
                dataFile = blobService.getFile(this.jobId, taskInfoKey);
                taskInformation = (TaskInformation)InstantiationUtil.deserializeObject((InputStream)new BufferedInputStream(Files.newInputStream(dataFile.toPath(), new OpenOption[0])), (ClassLoader)this.getClass().getClassLoader());
                taskInformationCache.put(this.jobId, taskInfoKey, taskInformation);
            }
            this.taskInformation = taskInformation.deepCopy();
        }
        if (this.serializedTaskRestore == null) {
            this.taskRestore = null;
        } else if (this.serializedTaskRestore instanceof Offloaded) {
            PermanentBlobKey blobKey = ((Offloaded)this.serializedTaskRestore).serializedValueKey;
            Preconditions.checkNotNull((Object)blobService);
            File dataFile2 = blobService.getFile(this.jobId, blobKey);
            this.taskRestore = (JobManagerTaskRestore)InstantiationUtil.deserializeObject((InputStream)new BufferedInputStream(Files.newInputStream(dataFile2.toPath(), new OpenOption[0])), (ClassLoader)this.getClass().getClassLoader());
        }
        for (InputGateDeploymentDescriptor inputGate : this.inputGates) {
            inputGate.tryLoadAndDeserializeShuffleDescriptors(blobService, this.jobId, shuffleDescriptorsCache);
        }
    }

    public String toString() {
        return String.format("TaskDeploymentDescriptor [execution id: %s, produced partitions: %s, input gates: %s]", this.executionId, TaskDeploymentDescriptor.collectionToString(this.producedPartitions), TaskDeploymentDescriptor.collectionToString(this.inputGates));
    }

    private static String collectionToString(Iterable<?> collection) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[");
        for (Object elem : collection) {
            strBuilder.append(elem);
        }
        strBuilder.append("]");
        return strBuilder.toString();
    }

    public static class Offloaded<T>
    extends MaybeOffloaded<T> {
        private static final long serialVersionUID = 4544135485379071679L;
        public PermanentBlobKey serializedValueKey;

        public Offloaded() {
        }

        public Offloaded(PermanentBlobKey serializedValueKey) {
            this.serializedValueKey = (PermanentBlobKey)Preconditions.checkNotNull((Object)serializedValueKey);
        }
    }

    public static class NonOffloaded<T>
    extends MaybeOffloaded<T> {
        private static final long serialVersionUID = 4246628617754862463L;
        public SerializedValue<T> serializedValue;

        public NonOffloaded() {
        }

        public NonOffloaded(SerializedValue<T> serializedValue) {
            this.serializedValue = (SerializedValue)Preconditions.checkNotNull(serializedValue);
        }
    }

    public static class MaybeOffloaded<T>
    implements Serializable {
        private static final long serialVersionUID = 5977104446396536907L;
    }
}

