/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.stats;

import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.shaded.guava33.com.google.common.collect.ImmutableSet;
import org.apache.flink.shaded.guava33.com.google.common.collect.Maps;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStatsRequestCoordinator<T, V> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final int NUM_GHOST_SAMPLE_IDS = 10;
    protected final Object lock = new Object();
    protected final Executor executor;
    protected final Duration requestTimeout;
    @GuardedBy(value="lock")
    protected final Map<Integer, PendingStatsRequest<T, V>> pendingRequests = new HashMap<Integer, PendingStatsRequest<T, V>>();
    @GuardedBy(value="lock")
    protected final ArrayDeque<Integer> recentPendingRequestIds = new ArrayDeque(10);
    @GuardedBy(value="lock")
    protected int requestIdCounter;
    @GuardedBy(value="lock")
    protected boolean isShutDown;

    public TaskStatsRequestCoordinator(Executor executor, Duration requestTimeout) {
        Preconditions.checkNotNull((Object)requestTimeout, (String)"The request timeout must cannot be null.");
        Preconditions.checkArgument((requestTimeout.toMillis() >= 0L ? 1 : 0) != 0, (Object)"The request timeout must be non-negative.");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.requestTimeout = requestTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFailedResponse(int requestId, @Nullable Throwable cause) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isShutDown) {
                return;
            }
            PendingStatsRequest<T, V> pendingRequest = this.pendingRequests.remove(requestId);
            if (pendingRequest != null) {
                this.log.info("Cancelling request {}", (Object)requestId, (Object)cause);
                pendingRequest.discard(cause);
                this.rememberRecentRequestId(requestId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isShutDown) {
                this.log.info("Shutting down task stats request coordinator.");
                for (PendingStatsRequest<T, V> pending : this.pendingRequests.values()) {
                    pending.discard(new RuntimeException("Shut down"));
                }
                this.pendingRequests.clear();
                this.recentPendingRequestIds.clear();
                this.isShutDown = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSuccessfulResponse(int requestId, ImmutableSet<ExecutionAttemptID> executionIds, T result) {
        Object object = this.lock;
        synchronized (object) {
            PendingStatsRequest<T, V> pending;
            if (this.isShutDown) {
                return;
            }
            String ids = executionIds.stream().map(ExecutionAttemptID::toString).collect(Collectors.joining(", "));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Collecting stats sample {} of tasks {}", (Object)requestId, (Object)ids);
            }
            if ((pending = this.pendingRequests.get(requestId)) != null) {
                pending.collectTaskStats(executionIds, result);
                if (pending.isComplete()) {
                    this.pendingRequests.remove(requestId);
                    this.rememberRecentRequestId(requestId);
                    pending.completePromiseAndDiscard();
                }
            } else if (this.recentPendingRequestIds.contains(requestId)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received late stats sample {} of tasks {}", (Object)requestId, (Object)ids);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Unknown request ID %d.", requestId));
            }
        }
    }

    private void rememberRecentRequestId(int sampleId) {
        if (this.recentPendingRequestIds.size() >= 10) {
            this.recentPendingRequestIds.removeFirst();
        }
        this.recentPendingRequestIds.addLast(sampleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int getNumberOfPendingRequests() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingRequests.size();
        }
    }

    @NotThreadSafe
    protected static abstract class PendingStatsRequest<T, V> {
        protected final int requestId;
        protected final long startTime;
        protected final Set<Set<ExecutionAttemptID>> pendingTasks;
        protected final Map<ImmutableSet<ExecutionAttemptID>, T> statsResultByTaskGroup;
        protected final CompletableFuture<V> resultFuture;
        protected boolean isDiscarded;

        protected PendingStatsRequest(int requestId, Collection<? extends Set<ExecutionAttemptID>> tasksToCollect) {
            this.requestId = requestId;
            this.startTime = System.currentTimeMillis();
            this.pendingTasks = new HashSet<Set<ExecutionAttemptID>>(tasksToCollect);
            this.statsResultByTaskGroup = Maps.newHashMapWithExpectedSize((int)tasksToCollect.size());
            this.resultFuture = new CompletableFuture();
        }

        protected boolean isComplete() {
            this.checkDiscarded();
            return this.pendingTasks.isEmpty();
        }

        protected void discard(Throwable cause) {
            if (!this.isDiscarded) {
                this.pendingTasks.clear();
                this.statsResultByTaskGroup.clear();
                this.resultFuture.completeExceptionally(new RuntimeException("Discarded", cause));
                this.isDiscarded = true;
            }
        }

        protected void collectTaskStats(ImmutableSet<ExecutionAttemptID> executionId, T taskStatsResult) {
            this.checkDiscarded();
            if (!this.pendingTasks.remove(executionId)) {
                if (this.isComplete()) {
                    throw new IllegalStateException("Completed");
                }
                throw new IllegalArgumentException("Unknown task " + String.valueOf(executionId));
            }
            this.statsResultByTaskGroup.put(executionId, taskStatsResult);
        }

        protected void checkDiscarded() {
            if (this.isDiscarded) {
                throw new IllegalStateException("Discarded");
            }
        }

        protected void completePromiseAndDiscard() {
            if (!this.isComplete()) {
                throw new IllegalStateException("Not completed yet");
            }
            this.isDiscarded = true;
            long endTime = System.currentTimeMillis();
            V combinedStats = this.assembleCompleteStats(endTime);
            this.resultFuture.complete(combinedStats);
        }

        public CompletableFuture<V> getStatsFuture() {
            return this.resultFuture;
        }

        protected abstract V assembleCompleteStats(long var1);
    }
}

