/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filemerging.DirectoryStreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileMergingCheckpointStateOutputStream;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageLocation;

public class FsMergingCheckpointStorageLocation
extends FsCheckpointStorageLocation {
    private final FileMergingSnapshotManager.SubtaskKey subtaskKey;
    private final FileMergingSnapshotManager fileMergingSnapshotManager;
    private final long checkpointId;
    private final Supplier<FsCheckpointStorageLocation> backwardsConvertor;

    public FsMergingCheckpointStorageLocation(FileMergingSnapshotManager.SubtaskKey subtaskKey, FileSystem fileSystem, Path checkpointDir, Path sharedStateDir, Path taskOwnedStateDir, CheckpointStorageLocationReference reference, int fileStateSizeThreshold, int writeBufferSize, FileMergingSnapshotManager fileMergingSnapshotManager, long checkpointId) {
        super(fileSystem, checkpointDir, sharedStateDir, taskOwnedStateDir, reference, fileStateSizeThreshold, writeBufferSize);
        this.subtaskKey = subtaskKey;
        this.checkpointId = checkpointId;
        this.fileMergingSnapshotManager = fileMergingSnapshotManager;
        this.backwardsConvertor = () -> new FsCheckpointStorageLocation(fileSystem, checkpointDir, sharedStateDir, taskOwnedStateDir, reference, fileStateSizeThreshold, writeBufferSize);
    }

    public CheckpointStreamFactory toNonFileMerging() {
        return this.backwardsConvertor.get();
    }

    public DirectoryStreamStateHandle getExclusiveStateHandle() {
        return this.fileMergingSnapshotManager.getManagedDirStateHandle(this.subtaskKey, CheckpointedStateScope.EXCLUSIVE);
    }

    public DirectoryStreamStateHandle getSharedStateHandle() {
        return this.fileMergingSnapshotManager.getManagedDirStateHandle(this.subtaskKey, CheckpointedStateScope.SHARED);
    }

    @Override
    public boolean canFastDuplicate(StreamStateHandle stateHandle, CheckpointedStateScope scope) throws IOException {
        return false;
    }

    @Override
    public List<StreamStateHandle> duplicate(List<StreamStateHandle> stateHandles, CheckpointedStateScope scope) throws IOException {
        return null;
    }

    @Override
    public FileMergingCheckpointStateOutputStream createCheckpointStateOutputStream(CheckpointedStateScope scope) throws IOException {
        return this.fileMergingSnapshotManager.createCheckpointStateOutputStream(this.subtaskKey, this.checkpointId, scope);
    }

    @Override
    public void reusePreviousStateHandle(Collection<? extends StreamStateHandle> previousHandle) {
        this.fileMergingSnapshotManager.reusePreviousStateHandle(this.checkpointId, previousHandle);
    }

    @Override
    public boolean couldReuseStateHandle(StreamStateHandle stateHandle) {
        return this.fileMergingSnapshotManager.couldReusePreviousStateHandle(stateHandle);
    }

    @Override
    public String toString() {
        return "FsMergingCheckpointStorageLocation {subtaskKey=" + String.valueOf(this.subtaskKey) + ", FileMergingSnapshotManager=" + String.valueOf(this.fileMergingSnapshotManager) + ", checkpointId=" + this.checkpointId + "}";
    }
}

