/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;

public class CheckpointMetaData
implements Serializable {
    private static final long serialVersionUID = -2387652345781312442L;
    private final long checkpointId;
    private final long timestamp;
    private final long receiveTimestamp;

    public CheckpointMetaData(long checkpointId, long timestamp) {
        this(checkpointId, timestamp, System.currentTimeMillis());
    }

    public CheckpointMetaData(long checkpointId, long timestamp, long receiveTimestamp) {
        this.checkpointId = checkpointId;
        this.timestamp = timestamp;
        this.receiveTimestamp = receiveTimestamp;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getReceiveTimestamp() {
        return this.receiveTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointMetaData that = (CheckpointMetaData)o;
        return this.checkpointId == that.checkpointId && this.timestamp == that.timestamp && this.receiveTimestamp == that.receiveTimestamp;
    }

    public int hashCode() {
        int result = (int)(this.checkpointId ^ this.checkpointId >>> 32);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (int)(this.receiveTimestamp ^ this.receiveTimestamp >>> 32);
        return result;
    }

    public String toString() {
        return "CheckpointMetaData{checkpointId=" + this.checkpointId + ", receiveTimestamp=" + this.receiveTimestamp + ", timestamp=" + this.timestamp + "}";
    }
}

