/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.co;

import org.apache.flink.streaming.api.operators.co.IntervalJoinOperator;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class BufferEntryMatchers {
    public static <T> Matcher<IntervalJoinOperator.BufferEntry<T>> bufferEntry(Matcher<T> elementMatcher, Matcher<Boolean> hasBeenJoinedMatcher) {
        return new IsBufferEntry<T>(elementMatcher, hasBeenJoinedMatcher);
    }

    static class IsBufferEntry<T>
    extends TypeSafeDiagnosingMatcher<IntervalJoinOperator.BufferEntry<T>> {
        private final Matcher<T> elementMatcher;
        private final Matcher<Boolean> hasBeenJoinedMatcher;

        public IsBufferEntry(Matcher<T> elementMatcher, Matcher<Boolean> hasBeenJoinedMatcher) {
            this.elementMatcher = elementMatcher;
            this.hasBeenJoinedMatcher = hasBeenJoinedMatcher;
        }

        protected boolean matchesSafely(IntervalJoinOperator.BufferEntry<T> item, Description mismatchDescription) {
            mismatchDescription.appendText("BufferEntry with element ");
            mismatchDescription.appendValue(item.getElement());
            mismatchDescription.appendText(" with hasBeenJoined ");
            mismatchDescription.appendValue((Object)item.hasBeenJoined());
            return this.elementMatcher.matches(item.getElement()) && this.hasBeenJoinedMatcher.matches((Object)item.hasBeenJoined());
        }

        public void describeTo(Description description) {
            description.appendText("BufferEntry with element ");
            this.elementMatcher.describeTo(description);
            description.appendText(" with hasBeenJoined ");
            this.hasBeenJoinedMatcher.describeTo(description);
        }
    }
}

